# User guides 

TDL and TOP can be used in different ways. Depending on the specific goals, different parts of TDL and TOP may be relevant for a given usage scenario. 
For different starting points and end goals, the following common use cases may come into question:

 - [Selected TOP user scenarios](UserScenarios.md#selected-top-user-scenarios)
 
    - [User control of the analysis level](UserScenarios.md#sec-user-control-of-the-analysislevel)
    - [Textual modelling](UserScenarios.md#sec-textual-modelling)
    - [TDL Wizards and Perspective](UserScenarios.md#sec-tdl-wizards-and-perspective)
    - [Graphical modelling](UserScenarios.md#sec-graphical-modelling)
    - [Importing protocol specifications](UserScenarios.md#sec-importing-protocol-specifications)
        - [Using TDL with OpenAPI™ Specifications](UserScenarios.md#sec-using-tdl-with-openapi-specifications)
        - [Using TDL with ASN.1 Specifications](UserScenarios.md#sec-using-tdl-with-asn-specifications)
        - [Using TDL with YANG Specifications](UserScenarios.md#sec-using-tdl-with-yang-specifications)>
    - [Creating test objectives based on TDL meta-model](UserScenarios.md#sec-creating-test-objectives-based-on-tdl-meta-model)
        - [Unified Definition of Test Puposes and Test Descriptions](UserScenarios.md#unified-definition-of-test-purposes-and-test-descriptions)
    - [Generate TD from TO](UserScenarios.md#sec-generate-td-from-to)
    - [Export to Word](UserScenarios.md#sec-export-to-word)
    - [Conversion to TTCN-3](UserScenarios.md#sec-conversion-to-tttn3)
 - [Defining Structured Test Objectives](UserScenarios.md#sec-defining-structured-test-objectives)
 - [Transforming Structured Test Objectives into Test Descriptions](UserScenarios.md#sec-transforming-structured-test-objectives-into-test-descriptions)
 - [Defining Test Descriptions](UserScenarios.md#sec-defining-test-descriptions)
 - [Transforming Test Descriptions into TTCN-3 Test Cases](UserScenarios.md#sec-transforming-test-descriptions-into-ttcn-3-test-cases)
 

  



## Selected TOP user scenarios <a name="selected-top-user-scenarios"></a>


### Overview

This section describes a set of user scenarios that illustrate how the features of the TOP tools can be used for specific testing tasks.


### User control of the analysis level <a name="sec-user-control-of-the-analysislevel"></a>

<a name="uc1-openclose"></a>
1. **Usage scenario:** The user saves and re-opens an incomplete TDL specification. The incomplete specification and associated analysis results are maintained.

2. **Usage scenario:** Incompatible assignment of types, e.g. assignment of a boolean value to integer type or exceeding the limit of a restricted list type (collection).  

3. **Usage scenario:** The user may set the level of analysis performed by TOP tool when developing the TDL test model. 

From the TDL toolbar shown in [Figure TDL toolbar](#figure-TDL-toolbar) the analysis level of the specification can be set.

<figure style="margin-left:auto; margin-right:auto; width:20%"><a id="figure-TDL-toolbar"></a>
  <img src="images/TdlToolbar.png" alt="TDL toolbar">
  <figcaption style="text-align:center; font-weight:bold">Figure 1: TDL toolbar</figcaption>
</figure>


The left "V" button sets the constraint validation to be automatically performed when editing the model. The selection mode is shown by marking the button with a darker 
shade when constraint validation is active. The rightmost "V" button causes the model to be analysed for syntactical errors. Errors are shown in the editor and in the problem view. 
Alternatively these settings can be controlled from the TDL menu shown in [Figure 2](#figure-tdl-menu-items).


<figure style="margin-left:auto; margin-right:auto; width:20%"><a id="figure-tdl-menu-items" ></a>
  <img src="images/TdlMenuList.png" alt="TDL Menu items">
  <figcaption style="text-align:center; font-weight:bold">Figure 2: TDL Menu items</figcaption>
</figure>


### Textual modelling <a name="sec-textual-modelling"></a>


1.	**Usage scenario:** Refactoring and renaming  

Reuse of existing TDL specification for which a slight modification is needed to use it in a context. E.g. a package containing TDL type definitions or configuration declarations may be re-used in a specific test specification context. To increase the readability the TDL TOP tool refactoring features may be used.
To use the rename feature, select an instance of an element and from the options when right-click on the mouse select option "Rename Element" (alternatively use key shortcut Alt + Shift + R). Type in the new element name in the dialog box.


<figure style="margin-left:auto; margin-right:auto; width:30%">
<img src="images/RenameDialog.png" alt="Rename dialog">
<figcaption style="text-align:center; font-weight:bold">Figure 3: Rename dialog box</figcaption>   
</figure>


In case the selected element is local to a single file the rename feature is executed inline without the Rename Element dialog.

<ol start=2>
<li> <b>Usage scenario:</b> Code formatting and syntax highlighting</li>
</ol>

The syntax coloring can be set from the "Syntax Coloring" dialog box: Open the "Window" menu and select "Preferences". Select the TDL tool used, ("TDLan2", "TDLtx", or "TDLtxi"), expand the subitems and select "Syntax Coloring".


<figure style="margin-left:auto; margin-right:auto; width:70%"><a id="figure-code-formatting-settings-dialog-box" ></a>
<img src="images/SyntaxColoring.png" alt="Code formatting settings">
<figcaption style="text-align:center; font-weight:bold">Figure 4: Code formatting settings dialog box</figcaption>   
</figure>


In the code formatting dialog box the preferences for different syntax elements can be set, see <a href=#figure-code-formatting-settings-dialog-box>Figure 4</a>.

<ol start=3>
  <li>  <b>Usage scenario:</b> Syntax auto complete</li>
</ol>

To use the syntax auto complete feature type in an initial part of a keyword or model element, press "Ctrl + Space", and the syntax auto complete options available in the context are displayed.


<figure style="margin-left:auto; margin-right:auto; width:70%">
<img src="images/SyntaxAutoCompletion.png" alt="Syntax auto complete">
<figcaption style="text-align:center; font-weight:bold">Figure 5: Syntax auto complete example</figcaption>   
</figure>


Press "Enter" and the selected text is inserted.

<ol start=4>
  <li> <b>Usage scenario:</b> Validation results presentation </li>
</ol>

The TOP tools support syntax check for the textual and graphical notations defined in the TDL standard. Syntax errors are indicated in the Problems view as well as in the editor 
as shown in <a href=#figure-syntax-error-presentation>Figure 6</a>.


<figure style="margin-left:auto; margin-right:auto; width:70%"><a id="figure-syntax-error-presentation" ></a>
<img src="images/syntaxerror.png" alt="Syntax error presentation">
<figcaption style="text-align:center; font-weight:bold">Figure 6: Syntax error presentation</figcaption>   
</figure>


The TOP tool offers semantic constraints check of a TDL specification. When this check is to be performed can be controlled from the TDL tool bar or the TDL menu item list. 
Either the check is performed when the "Validate TDL model" is selected or the check is performed automatically when the TDL model is updated, if the "Automatically validate 
TDL model" is selected. In <a href=#figure-constraint-error-presentation>Figure 7</a> an example of a semantics check is illustrated.


<figure style="margin-left:auto; margin-right:auto; width:70%"><a id="figure-constraint-error-presentation" ></a>
<img src="images/ValidationView.png" alt="Constraint error presentation">
<figcaption style="text-align:center; font-weight:bold">Figure 7: Constraint error presentation</figcaption>   
</figure>


<ol start=5><a id="us-templates-usage-and-definition"></a>
  <li> <b>Usage scenario:</b> Templates - usage and definition </li>
</ol>  
  
For each of the notations supported by the TOP tools the specific editor provides templates available in the context of the cursor position. The templates available at a given 
cursor position are shown when "Ctrl + Space" are pressed. When a template is selected pressing "Enter" inserts the template and allows for parameters to be modified.
An example of templates available in the context of a configuration specification is shown in <a href=#figure-templates-available-in-a-configuration-specification-context>Figure 8</a>.


<figure style="margin-left:auto; margin-right:auto; width:70%"><a id="figure-templates-available-in-a-configuration-specification-context" ></a>
<img src="images/TemplatesInContext.png" alt="Templates available in a configuration specification context">
<figcaption style="text-align:center; font-weight:bold">Figure 8: Templates available in a configuration specification context</figcaption>   
</figure>


The user may define additional templates for the different editors available in the TOP tool. The template editor is accessed via the "Window" menu item, option "Preferences". 
From the Preferences dialog box the specific TOP editor can be selected and user-defined templates be created. <a href=#figure-template-dialog-box>Figure 9</a> illustrates a list of templates defined for the 
TDLtx editor.


<figure style="margin-left:auto; margin-right:auto; width:70%"><a id="figure-template-dialog-box"></a>
<img src="images/TDLtxTemplates.png" alt="Template dialog box">
<figcaption style="text-align:center; font-weight:bold">Figure 9: Template dialog box</figcaption>   
</figure>


### TDL Wizards and Perspective  <a name="sec-tdl-wizards-and-perspective"></a>

Wizards provide support to create functional TDL project either with textual or graphical models according to user choice:
1.	**User scenario:** Create new TDL project
2.	**User scenario:** Reference to predefined model elements
3.	**User scenario:** Using predefined skeletons
4.	**User scenario:** Importing interface specifications

In order to create a new TDL specification:- Select from File menu item New and in the submenu select "Project". In the dialog box "Select a wizard", select the wanted 
TDL project, e.g. TDLtx for a textual TDL specification.


<figure style="margin-left:auto; margin-right:auto; width:50%"><a id="figure-wizard-selection-dialog-box"></a>
<img src="images/NewProjectSelectWizard_TextualProject.png" alt="Wizard selection dialog box">
<figcaption style="text-align:center; font-weight:bold">Figure 10: Wizard selection dialog box</figcaption>   
</figure>


Press "Next" and in the dialog box specify a name of the project to be create. If the default location is not to be used, uncheck the "Use default location" and specify 
the location of the project.


<figure style="margin-left:auto; margin-right:auto; width:50%"><a id="figure-creating-a-new-template-tdl-project"></a>
<img src="images/NewProjectTextualProjectName.png" alt="Creating a new template TDL project">
<figcaption style="text-align:center; font-weight:bold">Figure 11: Creating a new template TDL project</figcaption>   
</figure>


Select "Next" to open the dialog box for select among parameterized TDL textual project templates.


<figure style="margin-left:auto; margin-right:auto; width:50%"><a id="figure-create-new-tdl-project-with-support-for-openapi"></a>
<img src="images/NewProjectSelectTemplate.png" alt="Create new TDL project with support for OpenAPI">
<figcaption style="text-align:center; font-weight:bold">Figure 12: Create new TDL project with support for OpenAPI</figcaption>   
</figure>



Select template "TDLtx" and press "Next" to get further options to configure the TDL project.


<figure style="margin-left:auto; margin-right:auto; width:50%"><a id="figure-create-new-TDL-project-using-the-advanced-options-features"></a>
<img src="images/NewProjectSelectBasicTDLtxProject.png" alt="Create new TDL project with advanced options features">
<figcaption style="text-align:center; font-weight:bold">Figure 13: Create new TDL project using the advanced options features</figcaption>   
</figure>



In this dialog box the additional properties of the project may be configured.
If "Advanced" option is set the following options can be selected: 

- The name of path of the project files
- The imported packages
- The name of the project package, default is "Main"

### Graphical modelling  <a name="sec-graphical-modelling"></a>


1. **User scenario:** The TOP tool should provide ways to manage diagrams of model elements (create, delete, rename, open).
2. **User scenario:** Visual representation of all model elements should be implemented according to specification.
3. **User scenario:** All model elements and features should be editable either directly on the diagram or via property view.
4. **User scenario:** Negative validation results should be indicated graphically and linked to problem reports.

To define a TDL model using the graphical editor of the TOP tools, select menu "File" and in the menu select "New "and in the sub-menu list select "TDL project" or 
use shortcut "Alt-Shift-N". The dialog box shown in <a href=#figure-create-a-new-tdl-project-using-the-graphical-editor>Figure 14</a> appears and a project name can be specified.


<figure style="margin-left:auto; margin-right:auto; width:50%"><a id="figure-create-a-new-tdl-project-using-the-graphical-editor"></a>
<img src="images/TDLgrNewProj.png" alt="Create new TDL graphical project">
<figcaption style="text-align:center; font-weight:bold">Figure 14: Create a new TDL project using the graphical editor</figcaption>   
</figure>



When the "Finish" button is selected the project is created. In the "Project Explorer " select the project, press the right mouse button, and select option 
"Create Representation" and the dialog box shown in <a href=#figure-create-a-new-diagram>Figure 15</a> allow to create a new diagram.


<figure style="margin-left:auto; margin-right:auto; width:50%"><a id="figure-create-a-new-diagram"></a>
<img src="images/TDLgrNewRepresentation.png" alt="Create new TDL graphical diagram">
<figcaption style="text-align:center; font-weight:bold">Figure 15: Create a new diagram</figcaption>   
</figure>


There are two types of diagrams to create:
 
- "Generic TDL" diagram used to specify the package structure, test descriptions, configurations and data;
- "TDL Behaviour" diagram that defines the behaviour of a test description.

Select the type of diagram to be created, assign a name to the diagram, and press "Finish" to create the diagram.

NOTE:	Initially it is only possible to create a "Generic TDL" diagram as to create a "TDL Behaviour" diagram at least one test description is needed.

The editors for the two types of diagrams provides access to all graphical elements of the TDL language. The textual parameters can be edited either directly in the graphical 
element or in the Properties View of a selected element. In <a href=#figure-generic-tdl-diagram-editor>Figure 16</a> the editor for "Generic TDL " diagrams is shown. 


<figure style="margin-left:auto; margin-right:auto; width:50%"><a id="figure-generic-tdl-diagram-editor"></a>
<img src="images/GenericTdlGrEditor.png" alt="Generic TDL diagram editor">
<figcaption style="text-align:center; font-weight:bold">Figure 16: Generic TDL diagram editor</figcaption>   
</figure>



Both diagram editors have a pane with all the elements that can be used in the diagram. From the top tool bar a number of general edit functions are available, e.g. select 
all elements, show and hide elements. Also from the top tool bar the export diagram as an image file is available. The "Properties" view of the editor allows to define the 
textual parameters of a selected graphical element.

### Importing protocol specifications  <a name="sec-importing-protocol-specifications"></a>

The TOP tools support importing external data specifications to TDL data representations with mapping information to the original data specifications. All importers for the 
external use the "Translate Input to TDL Model" from the "TDL" menu or alternatively the >T> icon on the TDL tool bar. The generated TDL file depends on the type of project 
the external specification is imported to. The naming convention for the TDL file generated is the original file name extended with "-generated" and with extension according 
to the importing TDL model type.

1. **Usage scenario:** Importing OpenAPI specifications according to <a href="https://www.etsi.org/deliver/etsi_eg/203600_203699/203647/01.01.01_60/eg_203647v010101p.pdf" target="_blank">ETSI EG 203 647</a>.

For OpenAPI specifications the TOP tools currently supports:
- Importing of data definitions under components/schemas.
- Data mappings to the base OpenAPI definition for traceability.
- Data mappings to the target (Java) data implementation derived from the OpenAPI definitions for executability.


#### Using TDL with OpenAPI™ Specifications  <a name="sec-using-tdl-with-openapi-specifications"></a>

### Overview

The <a href="https://swagger.io/specification/" target="_blank">OpenAPI™ Specification</a> (previously known as the Swagger Specification) is a notation for the specification of interfaces for RESTful web services. 
In addition to data-related information, OpenAPITM specifications also include paths to identify resources by means of URLs, along with applicable operations, 
and corresponding request and response specifications. While these can be used to derive skeletons for structured test objectives and test descriptions as 
outlined in <a href="https://www.etsi.org/deliver/etsi_eg/203600_203699/203647/01.01.01_60/eg_203647v010101p.pdf" target="_blank">ETSI EG 203 647 Methods for Testing and Specification (MTS); Methodology for RESTful APIs specifications and testing</a>,
within the present document, the focus is solely on data-related information. Further information and guidelines regarding 
the use of OpenAPI™ for specification and testing at ETSI can be found in <a href="https://www.etsi.org/deliver/etsi_eg/203600_203699/203647/01.01.01_60/eg_203647v010101p.pdf" target="_blank">ETSI EG 203 647</a>.

In addition to a set of primitive data types, OpenAPI™ provides means for defining structured data types. The specification is an extension of the 
<a href="https://datatracker.ietf.org/doc/html/draft-bhutton-json-schema-01" target="_blank">JSON schema</a>.
Data type schemas may be defined inline or in a schemas object which enables reuse of those definitions. In the present document, only the latter is 
considered. Future editions may add guidelines for inline data definitions as well.


The built-in primitive  types in OpenAPI™ are mapped to TDL according to the conventions in <a href=#table-openapi-built-in-type-mapping>Table 1</a>. The mapping relies on a TDL library of predefined types and constraints. 
As OpenAPI™ specifications may include format specifications for types, a generic constraint (OpenAPIFormat) with corresponding quantifiers may be used to capture this 
information in the derived TDL data model. Non-standard formats may be present in an OpenAPITM specification as well. The generic constraint can be used for such formats as well.



<table style="margin-left:auto; margin-right:auto"><a id="table-openapi-built-in-type-mapping"></a>
<caption style="font-weight:bold"> Table 1: OpenAPI™ Built-in Type Mapping </caption>
<tr>
  <th>OpenAPI™</th>  <th>Type in TDL</th>  <th>Constraints</th>  <th>Formats and Patterns</th>
</tr>
<tr>
  <td> integer </td> <td> integer </td>  <td> OpenAPIFormat </td> <td>  int32, int64 </td>
</tr>
<tr>
  <td> number </td> <td> String </td>  <td> OpenAPIFormat </td> <td> float, double </td>
</tr>
<tr>
  <td> string </td> <td> String </td>  <td> OpenAPIFormat </td> <td> e-mail, password </td>
</tr>
<tr>
  <td> boolean </td> <td> Boolean </td>  <td>             </td> <td>              </td>
</tr>
</table>


A structured type in OpenAPI™ is either an 'array' with member type declaration ('items' object) or an 'object' with a set of properties ('properties' object). Consequently, the transformation of OpenAPI™ data types into TDL data types involves the following conventions:
-  If the data type corresponds to one of the primitive data types within the OpenAPI™ library as indicated in <a href=#table-openapi-built-in-type-mapping>Table 1</a>, the 'Type' is mapped to the corresponding 'SimpleDataType' 
from <a href=#table-openapi-built-in-type-mapping>Table 1</a>.

- If the data type is an 'object', it is mapped to a 'StructuredDataType' with a 'name' corresponding to the name of the OpenAPI™ data type. 

- If the data type is an 'array', it is mapped to a 'CollectionDataType' with a 'name' corresponding to the name of the OpenAPI™ data type. The data type indicated in the 'items' object is mapped to the corresponding 
'DataType' as the 'itemType' of the 'CollectionDataType'. If 'minItems' and 'maxItems' are specified for the 'array', the corresponding predefined constraints need to be added to the 'CollectionDataType'.

- Each item in the 'properties' object of the 'object' object is mapped to a 'Member' within the corresponding 'StructuredDataType' with a 'name' 
  corresponding to the property. If a 'Member' with the same 'name' exists, no action is taken. All 'Members are to be marked as optional, except for 
  'Member's corresponding to properties which are listed in the 'required' array of the 'object'. The 'dataType' of the 'Member' corresponds to:
  
    - A new 'DataType' corresponding to the 'type' of the property with a 'name' prefixed with the 'name' of the containing 'StructuredDataType' 
      in case a property is of 'type' 'object'.
      
    - A 'SimpleDataType' corresponding to the 'type' of the property in case the 'SimpleDataType' is one of the predefined 'DataType's within the 
      OpenAPI™ library as indicated in <a href=#table-openapi-built-in-type-mapping>Table 1</a>. 
      
- Nested 'objects are transformed according to the conventions above.

- If the property contains an 'enum' array, it is mapped to an 'EnumDataType' with a 'name' corresponding to the name of the property. The items contained in the 'enum' array 
  are mapped to 'SimpleDataInstance's of the 'EnumDataType' that are contained in the 'EnumDataType'. 
  
- Corresponding 'DataElementMapping's are created for the defined data types. 'DataElementMapping's for 'DataType's derived from anonymous (inline) data types are not created. 
  The 'DataElementMapping's may include target platform mappings in addition to the source mappings to the OpenAPI™ specifications.
  
### Examples

As an example consider the OpenAPI™ snippet shown in <a href=#figure-openapi-example-including-nested-anonymous-data-types>Figure 17</a> and the derived TDL data type model snippet showing 
in <a href=#figure-corresponding-flattened-tdl-definitions-for-figure-17>Figure 18</a>. Corresponding 
'StructuredDataType's are created for both the 'Library' and 'LibraryBook' data types, as well as for the nested anonymous 'object's and 'array's, which 
 are prefixed with 'Library___' and 'LibraryBook___' accordingly. This would also apply to additional anonymous 'object's and 'array's nested further within 
 the 'object's. The 'dataType's for the corresponding 'Member's are then set accordingly. Finally, both source and target (for Java in this example) 
 'DataElementMapping's are provided.
 
 
<figure><a id="figure-openapi-example-including-nested-anonymous-data-types"></a>
<code>
    
    components:
      schemas:
        LibraryBook:
          type: object
          properties:
            title:
          type: string
            authors:
              type: array
              items:
                type: string
            reviewers:
              type: array
              items:
                type: string
        Library:
          type: object
          properties:
            address:
              type: string
            books:
              type: array
              items:
                $ref: '#/components/schemas/LibraryBook'
</code>
<figcaption style="text-align:center"> <b>Figure 17: OpenAPI™ example including nested anonymous data types</b></figcaption>
</figure>


<figure><a id="figure-corresponding-flattened-tdl-definitions-for-figure-17">
<code>
    
    Type LibraryBook (
        String title,
        LibraryBook___authors authors,
        LibraryBook___reviewers reviewers
    )
    Collection LibraryBook___authors of String
    Collection LibraryBook___reviewers of String
    
    Type Library (
        String address,
        Library___books books
    )
    Collection Library___books of LibraryBook
    
    Use "mapping_conventions.yaml" as SOURCE_MAPPING
    Use "generated/java" as TARGET_MAPPING
    Map LibraryBook to "#/components/schemas/LibraryBook" 
      in SOURCE_MAPPING as LibraryBook_SOURCE_MAPPING
    Map LibraryBook to "LibraryBook" 
      in TARGET_MAPPING as LibraryBook_TARGET_MAPPING
    Map Library to "#/components/schemas/Library" 
      in SOURCE_MAPPING as Library_SOURCE_MAPPING
    Map Library to "Library" 
      in TARGET_MAPPING as Library_TARGET_MAPPING
</code>
<figcaption style="text-align:center"> <b>Figure 18: Corresponding flattened TDL definitions for Figure 17</b></figcaption>
</figure>



<ol start=2>
  <li> <b>Usage scenario:</b> Importing RESTCONF and YANG specifications.</li>
</ol>

The TOP tools support for importing RESTCONF and YANG data specifications is offered by the conversion of JSON specifications. For YANG data specifications this means 
that they have to be converted to JSON specifications.

<ol start=3>
  <li> <b>Usage scenario:</b> Importing ASN.1 specifications.</li>
</ol>


 #### Using TDL with ASN.1 Specifications <a name="sec-using-tdl-with-asn-specifications"></a>


### Overview


<a href="https://www.itu.int/itu-t/recommendations/rec.aspx?rec=x.680" target="_blank">ASN.1 (Abstract Syntax Notation One) Recommendation ITU T X.680</a> 
is a standardized language for the specification of data types and data structures. As the name implies, the specifications are abstract 
and therefore independent of a specific target platform. The specifications provide the information about the structure and encoding of the data which can be processed by generators or compilers to produce 
data type implementations for the desired target language and platform, including codecs for encoding and decoding the data for transmission. While TDL is not concerned with the encoding and decoding at 
the specification level, in many cases the test execution platform needs to include codes for the operationalisation of the tests. 

When ASN.1 specifications are imported in TDL, the level of detail may vary from the bare essentials, including the data types only, to including additional constraints, and even encoding information 
(where applicable). The additional information can be utilised for early validation of the TDL specifications. While it is also possible to specify constant values in ASN.1, these are not covered in 
the guidelines at present.

ASN.1 includes a set of built-in types, some of which are mapped to TDL according to the conventions in <a href=#table-asn1-built-in-type-mapping>Table 2</a>. The mapping relies on a TDL library of predefined types and constraints. 
The generic constraints (ASN1String, ASN1DateTime, ASN1Real, ASN1ObjectIdentifier) may be used to provide additional patterns for the contents of data instances of the corresponding data types to facilitate 
validation. Alternatively, a tool may implement implicit validation based on the underlying types.


<table style="margin-left:auto; margin-right:auto"><a id="table-asn1-built-in-type-mapping"></a>
<caption> <b>Table 2: ASN.1 Built-in Type Mapping </b></caption>

<tr>
<th>ASN.1 Type</th>  <th>Type in TDL</th>  <th>Constraints</th>  <th> Patterns</th> <th> Examples </th>
</tr>
<tr>
  <td> <b>BITSTRING</b> </td>  <td> BITSTRING </td>  <td> ASN1String </td> <td> [0|1]+'B </td> <td> "1101'B", also "Named BITS" () </td>
</tr>
<tr>
  <td> <b>OCTETSTRING</b> </td>  <td> OCTETSTRING </td>  <td> ASN1String </td> <td>  [A-F|0-9]+'H  </td> <td> "A3B2'H", "10010'B" </td>
</tr>
<tr>
  <td> <b>BMPString</b> </td>  <td> BMPString </td>  <td> ASN1String </td> <td> 16 bit Character </td> <td> </td>
</tr>
<tr>
  <td> </b>IA5String</b> </td>  <td> IA5String </td>  <td> ASN1String </td> <td>  8 bit ASCII </td>  <td> "Hallo" </td>
</tr>
<tr>
  <td> <b>GeneralString</b> </td>  <td> GeneralString </td>  <td> ASN1String </td> <td>  all graphic/character sets, <br> SPACE, DELETE </td> <td> </td>
</tr>
<tr>
  <td> <b>NumericString</b> </td>  <td> NumericString </td>  <td> ASN1String </td> <td>  [0-9, SPACE]+  </td> <td> "34 8" </td>
</tr>
<tr>
  <td> <b>PrintableString</b> </td>  <td> PrintableString </td>  <td> ASN1String </td> <td>  [a-z,A-Z,'()+,-.?:/=,SPACE]  </td> <td "Black, Blue + Brown" </td>
</tr>
<tr>
  <td> <b>TeletexString</b> </td>  <td> TeletexString </td>  <td> ASN1String </td> <td>  CCITT T.101 </td> <td> </td>
</tr>
<tr>
  <td> <b>T61String</b> </td>  <td> T61String </td>  <td> ASN1String </td> <td>  CCITT T.101 </td>  <td>  </td>
</tr>
<tr>
  <td> <b>UniversalString</b> </td>  <td> UniversalString </td>  <td> ASN1String </td> <td> ISO10646 </td>  <td>   </td>
</tr>
<tr>
  <td> <b>UTF8String</b> </td>  <td> UTF8String </td>  <td> ASN1String </td> <td> ASCII + Control </td> <td>    </td>
</tr>
<tr>
  <td> <b>VideotexString</b> </td>  <td> VideotexString </td>  <td> ASN1String </td> <td> CCITT T.100, T.101 </td> <td>    </td>
</tr>
<tr>
  <td> <b>VisibleString</b> and <br> <b>ISO646String</b> </td>  <td> VisibleString </td>  <td> ASN1String </td> <td> ASCII Printing </td> <td>    </td>
</tr>
<tr>
  <td> <b>UTCTime</b>  </td>  <td> UTCTime  </td> <td> ASN1DateTime </td>  <td> YYMMDDhhmm[ss]Z </td> <td>  "991231235959+0200"  </td>
</tr>
<tr>
  <td> <b>GeneralizedTime</b> </td> <td> GeneralizedTime </td> <td> ASN1DateTime </td>  <td> YYYYMMDDHH[MM[SS[.fff]]]Z <br> (<a href="https://www.iso.org/iso-8601-date-and-time-format.html" target="_blank">ISO 8601 Date and time format</a>) </td> <td> "20200425175522.214+0200"  </td>
</tr>
<tr>
  <td> <b>DATE</b>  </td> <td> Date </td> <td> ASN1DateTime </td>   <td> YYYY-MM-DD </td> <td> "1636-09-18"  </td>
</tr>
<tr>
  <td> <b>TIME-OF-DAY</b>  </td> <td> TimeOfDay </td> <td> ASN1DateTime </td>   <td> HH:mm:ss </td> <td> "18:30:23"  </td>
</tr>
<tr>
  <td> <b>DATE-TIME</b>  </td>  <td> DateTime </td>  <td> ASN1DateTime </td>   <td> YYYY-MM-DDThh:mm:ss </td> <td> "2000-11-22T18:30:23"  </td>
</tr>
<tr>
  <td> <b>INTEGER</b> </td> <td> Integer </td>   <td>  </td>    <td>  </td>   <td>  </td>
</tr>
<tr>
  <td> <b>REAL</b> </td> <td> String </td>  <td> ASN1Real  </td>   <td>  </td>  <td>  </td>
</tr>
<tr>
  <td> <b>BOOLEAN</b> </td> <td> Boolean </td>   <td>  </td>   <td>  </td>  <td>  </td>
</tr>
<tr>
  <td> <b>NULL</b> </td> <td> Null </td>   <td>  </td>   <td>  </td>  <td>  </td>
</tr>
<tr>
  <td> <b>OBJECT IDENTIFIER</b> </td> <td> ObjectIdentifier </td>   <td> ASN1ObjectIdentifier </td>   <td>  </td> <td> id-ssp OBJECT IDENTIFIER ::= { itu-t (0)  <br> identified-organization (4) etsi (0) <br>  smart-secure-platform (3666) part1 (1) } </td>
</tr>

<tr>
  <td> <b>RELATIVE OBJECT IDENTIFIER<b> </td> <td> ObjectIdentifier </td>   <td> ASN1ObjectIdentifier </td>   <td>  </td> <td> Relative_id_ssp RELATIVE-OID ::= <br> { smart-secure-platform (3666) part1 (1) } </td>
</tr>
 
</table>



The transformation of ASN.1 data types into TDL data types involves the following conventions:

- If the data type corresponds to one of the predefined 'DataType's within the ASN.1 library as indicated in <a href=#table-asn1-built-in-type-mapping>Table 2</a>, the ASN.1 'Type' is mapped 
to the corresponding TDL 'SimpleDataType' from <a href=#table-asn1-built-in-type-mapping>Table 2</a>. For the supported ASN.1 types the following additional restrictions apply:
 
    -	NULL type is only used in the scope of a Choice type where if there is no information, the corresponding alternative is activated.

-	If the ASN.1 data type is a 'SequenceType', a 'SetType', or a 'ChoiceType', it is mapped to a 'StructuredDataType' with a 'name' corresponding to the name of the ASN.1 data type. 
In the case of 'ChoiceType', a 'Constraint' with the predefined 'union' 'ConstraintType' is applied to the corresponding 'StructuredDataType', and all 'Members are marked as optional.

- If the ASN.1 data type is a 'SequenceOfType' or a 'SetOfType', it is mapped to a 'CollectionDataType' with a 'name' corresponding to the name of the ASN.1 data type. The 'Type' indicated for 
the 'SequenceOfType' or 'SetOfType' is mapped to the corresponding 'DataType' as the 'itemType' of the 'CollectionDataType'.
  
- Each 'ComponentType' in the 'ComponentTypeList' of the 'SequenceType', 'SetType', or 'ChoiceType' is mapped to a 'Member' within the corresponding 'StructuredDataType' with a 'name' corresponding to the 
'identifier' of the 'ComponentType'. If a 'Member' with the same 'name' exists, no action is taken. The 'dataType' of the 'Member' corresponds to:

    - A new 'DataType' corresponding to the 'Type' of the 'ComponentType' with a 'name' prefixed with the 'name' of the containing 'StructuredDataType' in case a 'ComponentType' is directly contained within another 'ComponentType'.
     
    - A 'SimpleDataType' corresponding to the 'Type' of the 'ComponentType' in case the 'SimpleDataType' is one of the predefined 'DataType's within the ASN.1 library as indicated in <a href=#table-asn1-built-in-type-mapping>Table 2</a>. 

 - Nested 'ComponentType's are transformed according to the conventions above.
 
- If the ASN.1 data type is an 'EnumeratedType', it is mapped to an 'EnumDataType' with a 'name' corresponding to the name of the ASN.1 data type. The contained 'EnumerationItem's are mapped 
to 'SimpleDataInstance's of the 'EnumDataType' that are contained in the 'EnumDataType'. There are no guidelines for 'NamedNumber's at present. 

- Corresponding 'DataElementMapping's are created for the defined data types. 'DataElementMapping's for 'DataType's derived from anonymous (inline) data types are not created. 
The 'DataElementMapping's may include target platform mappings in addition to the source mappings to the ASN.1 specifications.

For the following built-in types not mentioned in <a href=#table-asn1-built-in-type-mapping>Table 2</a>, the transformations to TDL types are done as follows:

- UnrestrictedCharacterStringType: Replace the CHARACTER STRING type with its associated type obtained by expanding inner subtyping in the associated type of the CHARACTER STRING 
type (see clause 44.5 of <a href="https://www.itu.int/itu-t/recommendations/rec.aspx?rec=x.680" target="_blank">Recommendation ITU T X.680</a>) to the corresponding TDL type.

- EmbeddedPDVType: Replace any EMBEDDED PDV type with its associated type obtained by expanding inner subtyping in the associated type of the EMBEDDED PDV type
 (see clause 36.5 of <a href="https://www.itu.int/itu-t/recommendations/rec.aspx?rec=x.680" target="_blank">Recommendation ITU T X.680</a>) 
to the corresponding TDL type.

- ExternalType: replace the EXTERNAL type with its associated type obtained by expanding inner subtyping in the associated type of the EXTERNAL type 
(see clause 37.5 of <a href="https://www.itu.int/itu-t/recommendations/rec.aspx?rec=x.680" target="_blank">Recommendation ITU T X.680</a>))
to the corresponding TDL type.

- InstanceOfType: Replace the INSTANCE OF type with its associated type obtained by substituting INSTANCE OF DefinedObjectClass by its associated ASN.1 type (see clause C.7 of 
<a href="https://www.itu.int/itu-t/recommendations/rec.aspx?rec=x.681" target="_blank">Recommendation ITU T X.681</a> and 
map all ASN.1 types to their TDL types according to <a href=#table-asn1-built-in-type-mapping>Table 2</a>. 


### Examples


For example, as shown in <a href=#figure-asn1-example-including-nested-anonymous-data-types>Figure 19</a> and <a href=#figure-corresponding-tdl-definitions-excerpt-for-figure-19>Figure 20</a>, for 
the 'NodeDescriptor' and related type definitions taken from
<a href="https://www.etsi.org/deliver/etsi_ts/103600_103699/10366601/15.00.00_60/ts_10366601v150000p.pdf" target="_blank">ETSI TS 103 666-1, V15.0.0: Smart Secure Platform (SSP); Part 1: General characteristics (Release 15)</a>,
 a corresponding 'StructuredDataType' is created, including derived 'DataType's for the nested 'aNode' anonymous 'ContentType', as well as the 'aLink', 'aFile', and 'aDirectory' anonymous 
 'ContentType's nested further within the 'aNode' 'ContentType'. The 'dataType's for the corresponding 'Members are then set accordingly. The 'DataType' for the 'NodeIdentity' type as well 
 as the derived 'DataType' for the 'aNode' 'Member' are assigned a 'Constraint' with the 'union' 'ConstraintType'.


<figure><a id="figure-asn1-example-including-nested-anonymous-data-types">
<code>
    
    NodeDescriptor ::= SEQUENCE
    {
        aNodeName NodeName,  -- Node name
        aShortName UUID,  -- Short node name
        aNode CHOICE
        {
            aLink SEQUENCE
            {
                aLinkedFileIdentity NodeIdentity,  -- Identity of the linked SSP file
                aLinkedFileSize FileSize  -- Size of the linked SSP file
            },
            aFile SEQUENCE
            {
                aFileSize FileSize  -- Size of the SSP file
            },
            aDirectory SEQUENCE
            {
            }
        },
        aMetaData SEQUENCE OF MetaDatum OPTIONAL,  -- Optional meta data
        aACL SET OF AccessControl OPTIONAL  -- Access Control List attribute
    }
    
    /* Node identity */
    NodeName ::= UTF8String (SIZE(1..16))  -- node name encoded in UTF-8
    NodeReference ::= SEQUENCE (SIZE(1..6)) OF NodeName  -- pathname and node name
    
    NodeIdentity ::= CHOICE
    {
        aShortName UUID,  -- UUID of file reference using absolute pathname
        aNodeReference NodeReference  -- Node reference
    }
</code>
<figcaption style="text-align:center"> <b>Figure 19: ASN.1 example including nested anonymous data types</b></figcaption>
</figure>


<figure><a id="figure-corresponding-tdl-definitions-excerpt-for-figure-19">
<code>
     
      Type NodeDescriptor (
        aNodeName of type NodeName,
        aShortName of type UUID ,
        aNode of type NodeDescriptor___aNode ,
        optional aMetaData of type NodeDescriptor___aMetaData ,
        optional aACL of type NodeDescriptor___aACL
      );
      Type NodeDescriptor___aNode { union } (
        aLink of type NodeDescriptor___aNode___aLink,
        aFile of type NodeDescriptor___aNode___aFile ,
        aDirectory of type NodeDescriptor___aNode___aDirectory
      );
     
      Collection NodeDescriptor___aMetaData of type MetaDatum;
      Collection NodeDescriptor___aACL of type AccessControl;
      
      Type NodeIdentity { union } (
        aShortName of type UUID,
        aNodeReference of type NodeReference
      );
      Collection NodeReference of type NodeName;
      Type NodeDescriptor___aNode___aLink (
        aLinkedFileIdentity of type NodeIdentity,
        aLinkedFileSize of type FileSize
      );
      Type NodeDescriptor___aNode___aFile (
        aFileSize of type FileSize
      );
</code>
<figcaption style="text-align:center"> <b>Figure 20: Corresponding TDL definitions (excerpt) for Figure 19</b></figcaption>
</figure>


As an example consider the ASN.1 snippet shown in <a href=#figure-asn1-example-including-nested-anonymous-data-types>Figure 21</a> and the derived TDL data type 
model snippet showing in <a href=#figure-corresponding-flattened-tdl-definitions-excerpt-for-figure-21>Figure 22</a>. Corresponding 'StructuredDataType's are 
created for both the 'Library' and 'Document' data types, as well as for the nested anonymous 'ContentType's, which are prefixed with 'Library___' and 'Document___' accordingly. 
This would also apply to additional anonymous 'ContentType's nested further within the 'ContentType's. The 'dataType's for the corresponding 'Members are then set accordingly. 
The derived 'DataType' 'Document___number' for the 'number' 'ContentType' of type 'CHOICE' is assigned a 'Constraint' with the 'union' 'ConstraintType'. Default values are not 
present in the derived TDL data model, as TDL does not support default values for type definitions. However, a data type implementation in the target platform may include default 
values. In TDL it is possible to define a data instance which provides default values which can be overridden when the data instance is used. Finally, source 'DataElementMapping's 
are provided.


<figure><a id="figure-asn1-example-including-nested-anonymous-data-types">
<code>
    
     Library ::= SEQUENCE {
       address   UTF8String DEFAULT "Sophia-Antipolis, France", 
       documents SEQUENCE OF Document
     }
    
    Document ::= SEQUENCE {
       title     UTF8String (SIZE(1..128)),
       status    ENUMERATED {draft, published, historical},
       authors   SEQUENCE OF UTF8String,
       number    CHOICE { 
          es     INTEGER,  
          eg     INTEGER,
          tr     INTEGER  
       }  OPTIONAL,
       updated   DATE
    }
</code>
<figcaption style="text-align:center"> <b>Figure 21: ASN.1 example including nested anonymous data types</b></figcaption>
</figure>


<figure><a id="figure-corresponding-flattened-tdl-definitions-excerpt-for-figure-21">
<code>
    
    Type Library (
      address of type UTF8String,
      documents of type Library___documents
    );
    Type Document (
      title of type UTF8String,
      status of type Document___status ,
      authors of type Document___authors ,
      optional number of type Document___number ,
      updated of type Date
    );
    Collection Library___documents of type Document;
    Collection Document___authors of type UTF8String;
    Type Document___number { union } (
      es of type Integer,
      eg of type Integer ,
      tr of type Integer
    );
    Enumerated Document___status {
      Document___status draft;
      Document___status published;
      Document___status historical;
    }
    Use "example-1-library.asn" as SOURCE_MAPPING;
    Map Library to "Library" in SOURCE_MAPPING as Library_MAPPING;
    Map Document to "Document" in SOURCE_MAPPING as Document_MAPPING;
</code>
<figcaption style="text-align:center"> <b>Figure 22: Corresponding flattened TDL definitions (excerpt) for Figure 21</b></figcaption>
</figure>

#### Using TDL with YANG Specifications <a name="sec-using-tdl-with-yang-specifications"></a>

*TBD*

### Creating test objectives based on TDL meta-model <a name="sec-creating-test-objectives-based-on-tdl-meta-model"></a> 


1. **User scenario:** Use the core TDL syntax for specifying test objectives.

The TOP tool editors for the standardised textual syntax in <a href="https://www.etsi.org/deliver/etsi_es/203100_203199/20311908/01.02.01_60/es_20311908v010201p.pdf" target="_blank">ETSI ES 203 119-8</a> 
support the extended syntax for structured test objectives in <a href="https://www.etsi.org/deliver/etsi_es/203100_203199/20311904/01.05.01_60/es_20311904v010501p.pdf" target="_blank">ETSI ES 203 119-4</a>. 
Details on how to use one of the TOP tool textual editors to define structured test objectives are described below.



#### Unified Definition of Test Puposes and Test Descriptions <a name="unified-definition-of-test-purposes-and-test-descriptions"></a>


### Overview


With the standardised textual notation for TDL, a new unified syntax was also introduced to allow specifying test purpose-like test descriptions. 
Using this notation, users can start from a more abstract test purpose, and gradually add to the necessary details to reach executable specifications, 
all while using the same concepts and constructs, without the need to switch and transform between different notations. To achieve this, users can start 
with a template provided by the specialised syntax for 'Test Purpose Description's, which contains the necessary behaviour blocks and compartments, which 
reflect the structure of a 'Structured Test Objective'. While the structure is near identical, the contents are specified as TDL 'Behaviour's rather than 
TDL-TO 'EventOccurrence's. Thus, only the notation for 'Behaviour's is available and data and configuration definitions need to be available. However, 
the configuration and behaviour specifications can be simplified at first, e.g. by using 'Inline Action's which can be refined into more specific 
'Behaviour's such as 'Message's over time.   


<figure><a id="figure-unified-definition-of-test-purposes-and-test-descriptions">
<code>
    
    Objective TO_MOVE_OBJECT_UNIFIED {
        Description: "Move object to destination with unified test purpose description."
    }
    
    Test Purpose Description TP_MOVE_OBJECT_UNIFIED {
        Objective: TO_MOVE_OBJECT_UNIFIED
        Configuration: basic
        Expected behaviour 
        ensure that {
            when { 
                perform action: "the Controller sends the starting position" 
            } then {
                perform action: "the Object moves to the requested position"
            } 
        }
    }
</code>
<figcaption style="text-align:center"> <b>Figure 23: Unified definition of test purposes and test descriptions</b></figcaption>
</figure>


<figure><a id="figure-unified-definition-of-test-purposes-and-test-descriptions-with-refinements">
<code>
    
    Test Purpose Description TP_MOVE_OBJECT_UNIFIED {
      Objective: TO_MOVE_OBJECT_UNIFIED
      Configuration: basic
      Expected behaviour 
      ensure that {
          when { 
              perform action: "the Controller sends the starting position" 
              controller::wifi sends "x=21, y=21" to object::wifi
          } then {
              perform action: "the Object moves to the requested position"
              controller::wifi receives "x=21, y=21" from object::wifi
          } 
      }
    }
</code>
<figcaption style="text-align:center"> <b>Figure 24: Unified definition of test purposes and test descriptions with refinements</b></figcaption>
</figure>


<figure><a id="figure-unified-definition-of-test-purposes-and-test-descriptions-with-further-refinements">
<code>
    
    Test Purpose Description TP_MOVE_OBJECT_UNIFIED {
      Objective: TO_MOVE_OBJECT_UNIFIED
      Configuration: basic
      Expected behaviour 
      ensure that {
          when { 
              perform action: "the Controller sends the starting position" 
              controller::wifi sends position (x = 21, y = 21) to object::wifi
          } then {
              perform action: "the Object moves to the requested position"
              controller::wifi receives position (x = 21, y = 21) from object::wifi
          } 
      }
    }
</code>
<figcaption style="text-align:center"> <b>Figure 25: Unified definition of test purposes and test descriptions with further refinements</b></figcaption>
</figure>


As shown in <a href=#figure-unified-definition-of-test-purposes-and-test-descriptions>Figure 23</a>, the test objective is specified separately and referenced within the test 
purpose description. The test purpose description itself references a 
test confederation and has the familiar expected behaviour pattern with the when and then blocks. For simplicity, stimulus and response can be initially specified as inline 
actions. In this case, the action descriptions are expressed in plain text. At a later stage, the behaviour can be further refined, for example by using message exchanges, 
but without yet defining and using any the data types, as shown in <a href=#figure-unified-definition-of-test-purposes-and-test-descriptions-with-refinements>Figure 24</a>. 
Eventually, when the data types are known and defined, they can be used as subsequent 
refinement of the behaviour, as shown in <a href=#figure-unified-definition-of-test-purposes-and-test-descriptions-with-further-refinements>Figure 25</a>. Finally, they might 
even be defined as parameters, as the test purpose description gradually includes sufficient detail to become executable.

<figure><a id="figure-representation-of-figure-25-using-the-generic-test-description-syntax">
<code>
    
    Objective: TO_MOVE_OBJECT_UNIFIED
    Test Description TP_MOVE_OBJECT_UNIFIED uses basic {
      @Expected behaviour
      {
          @when
          {
              perform action : "the Controller sends the starting position"
              controller::wifi sends position ( x = 21, y = 21 ) to object::wifi
          }
          @then
          {
              perform action : "the Object moves to the requested position"
              object::wifi sends position ( x = 21, y = 21 ) to controller::wifi
          }
      }
    }
</code>	
<figcaption style="text-align:center"> <b>26: Representation of Figure 25 using the generic test description syntax</b></figcaption>
</figure>

As the unified notation is simply using annotated blocks with specialised syntax, the same structure can also be expressed by using the generic syntax for test descriptions, 
as shown in <a href=#figure-representation-of-figure-25-using-the-generic-test-description-syntax>Figure 26</a>. As the test purpose gradually becomes more detailed and more formalised, 
the annotated blocks could also eventually be dropped or extended with 
further annotations. Using this approach, there is no need for transformations between different notations and different conceptual representations. Is that the same model 
elements are used to express the full spectrum between more abstract and more concrete behaviour specifications. The level of detail can be refined over time as further 
information becomes available.





<ol start=2>
  <li> <b>User scenario:</b> Templates for TO backed by TD, also for constituent parts.</li>
</ol>

The TOP tool textual editors provides context sensitive templates for specification of structured test objectives. Further details on how to use templates can be found
<a href=#us-templates-usage-and-definition>here</a>. 


<ol id="UC_TemplateLibraryForBasiConfigs" start=3>
  <li> <b>User scenario:</b> Template library for basic configurations and types.</li>
</ol>

The extended syntax for structured test objectives allows for more complete test purpose specification requiring, e.g. configuration specification. For these elements the TOP tool editors provide a template library is available from the template collection of the editors.



### Generate TD from TO <a name="sec-generate-td-from-to"></a>


Lossless conversion of TDL test objectives to test descriptions is generally not possible due to conceptual differences between the formalisms. Some of the discrepancies may be overcome by annotating source (and target) models with appropriate information.

1. **User scenario:** Means to include predefined annotations with TDL models to help guide the conversion process. 

2. **User scenario:** Support for TO to TDL conversion according to element annotations or default (non-functional) mappings for cases where annotations are not provided.  

3. **User scenario:** Generated test descriptions contain references to test objectives from which they originate.  

As the conversion cannot be completely automated the process on how manual steps can support the transformation are defined in section
<a href=#sec-transforming-structured-test-objectives-into-test-descriptions>Transforming Structured Test Objectives into Test Descriptions</a>. The TOP tools currently supports:

- Transforming of inline data descriptions within EventOccurrences into corresponding data types.
- Generation of TestConfigurations based on the EventSequences within the Structured Test Objective.
- Generation of TestDescription skeletons based on the EventSequences within the Structured Test Objective with references to it.
- Importing of the base package and imported packages.

### Export to Word <a name="sec-export-to-word"></a>


An essential use case for TDL is its application in producing test specifications, which requires the conversion of models to printable format such as Microsoft Word:

1. **User scenario:** Export TDL diagrams as images.

2. **User scenario:** Export textual TDL test descriptions to be part of a Word document.

3. **User scenario:** Export test objectives as parts of a Word document.

The TOP tool graphical editors provide a function to export the current diagram as an image in the format of the users choice. The function is available via the "camera" button 
shown in <a href=#figure-generic-tdl-diagram-editor>Figure 16</a>.
Textual TDL code can be copied from the TDL editors.

The TOP tools provides a TDL-TO converter for Test Objectives to the Word table format. The TDL-TO converter supports both Structured Test Objectives defined in the example
 syntax and new the standardised notation. Template files allow to define the layout of the generated Word document. 
 In <a href="https://www.etsi.org/deliver/etsi_tr/103100_103199/103119/01.04.01_60/tr_103119v010401p.pdf" target="_blank">ETSI TR 103 119</a> clause 5.3.3 more information on the TDL-TO converter is defined.

### Conversion to TTCN-3 <a name="sec-conversion-to-tttn3"></a>


1. **User scenario:** Conversion of TDL models to TTCN-3 test suites 

The TOP tools support generation of TTCN-3 according to <a href="https://www.etsi.org/deliver/etsi_es/203100_203199/20311906/01.03.01_60/es_20311906v010301p.pdf" target="_blank">ETSI ES 203 119-6</a>. 
To use this feature use the T3 button in the TDL tool bar or the TDL Menu item "Transform TDL model to TTCN-3" 
with the model to be transformed open. In section <a href=#sec-transforming-test-descriptions-into-ttcn-3-test-cases>"Transforming Test Descriptions into TTCN-3 Test Cases"</a> additional 
information on the translation can be found.



## Defining Structured Test Objectives  <a name="sec-defining-structured-test-objectives"></a>


### Overview


TDL Structured Test Objective (TDL-TO) may be used in several ways in the test developments process. The process illustrated here is based on the 
test development process defined in <a href="https://www.etsi.org/deliver/etsi_eg/203100_203199/203130/01.01.01_60/eg_203130v010101p.pdf" target="_blank">ETSI EG 203 130 (V1.1.1)</a>.
The TDL-TO specifies a refinement of a 'TestObjective' and defines a formal description of a test objective, that may be the basis for a transformation to a TDL test description.

Developing a test specification from a base standard the first step after identifying the requirements to be tested, is to define the test objectives. 
The entities and events to check the test objectives may then be specified and finally arguments of events (data values) and timing constraints may be 
specified. The context in which the required behaviour executes is defined in the test configuration.

Then the parts of a complete TDL-TO specification are:

- Domain part.
- Data.
- Configuration.
- Test purpose behaviour.

The domain, data, and configuration parts are common to a set of test purpose behaviour descriptions, while each test purpose behaviour is specific 
to a single test objective. Test purpose behaviours are typically grouped based on different criteria, e.g. test for normal behaviour and test for 
invalid behaviour to form a test suite structure. In TDL-TO this structuring is supported by grouping of test purpose behaviours. To further structure 
a TDL-TO specification, the domain, data, configuration and test purpose behaviours may be also separated using the TDL package concept, to support 
re-use of basic data definitions and configurations.

### Domain part of TDL-TO


The domain part of a TDL-TO specification defines the PICS elements, entities, and events relevant for a set of TDL TOs.


<figure><a id="figure-tdl-to-domain-example">
<code>
    
     Domain {
            pics:
               - NONE
            ;
            entities:
                - EPC_PCRF_A
                - EPC_PCRF_B
                - EPC_PGW_A
                - EPC_PGW_B
                - EPC_MME_A
                - EPC_MME_B
                - IMS_HSS_A
                - IMS_HSS_B
            ;
            events:
                - receives
                - sends
                - triggers
                - detachment
                - invokes
                - create_session_request
                - delete_session_request
                - termination_SIP_signalling_session
            ;
</code>
<figcaption style="text-align:center"> <b>Figure 27: TDL-TO Domain example</b></figcaption>
</figure>
 

In <a href=#figure-tdl-to-domain-example>Figure 27</a> an example of a domain specification is shown. The example illustrates the definition of a single PICS value. The example also contains 
the definition of a list of entities that can be referenced in test configuration definitions and in event occurrences in the behaviour part. 
Finally, the example shows definition of events that may be referenced in the event occurrence parts of TDL-TO behaviour descriptions.

### Data definitions


In TDL-TO data may be used in the behaviour part without explicit declaration. However, in the data part of the TDLTO definition structured data types 
and structured data values may be specified.

<figure><a id="figure-tdl-to-data-definition-example">
<code>
    
      Data {
          type DiameterMessage;
      }
</code>
<figcaption style="text-align:center"> <b>Figure 28: TDL-TO data definition example</b></figcaption>
</figure>
 

<a href=#figure-tdl-to-data-definition-example>Figure 28</a> illustrates the specification of a single data type.

### Configuration


The configurations part of the TDL-TO specification defines by reference the context in which a TDL-TO is to be executed. The Configuration part 
may contain any number of test configuration as needed for the TDL-TOs to which it may be associated.


<figure><a id="figure-tdl-to-configuration-example">
<code>
    
      Configuration {
          Interface Type defaultGT accepts DiameterMessage;
          Component Type DiameterComp with gate g of type defaultGT;
          
            Test Configuration CF_VxLTE_INT
                  containing 
                      Tester component EPC_PGW_A of type DiameterComp
                      Tester component EPC_PCRF_A of type DiameterComp
                      SUT component IMS_A of type DiameterComp
                      connection between EPC_PGW_A.g and EPC_PCRF_A.g
            ;
            
            Test Configuration CF_VxLTE_RMI
                  containing 
                      Tester component EPC_PCRF_A of type DiameterComp
                      Tester component EPC_PCRF_B of type DiameterComp
                      SUT component IMS_A of type DiameterComp
                      connection between EPC_PCRF_A.g and EPC_PCRF_A.g
            ;
      }
</code>      
<figcaption style="text-align:center"> <b>Figure 29: TDL-TO configuration example</b></figcaption>
</figure>
 

The configuration part in <a href=#figure-tdl-to-configuration-example>Figure 29</a> shows the definition of two test configurations "CF_VxLTE_INT" and "CF_VxLTE_RMI". Both test configurations are 
based on the same component type "DiameterComp" and gate type "defaultGT". The 'defaultGT' is specified to accept instances of the datatype 'DiameterMessage'. 
The test configurations also specify the role of involved entities, as tester or SUT component.

### Test purpose behaviour


The test behaviour defines the behaviour of a TDL-TO to check a single test objective in terms of a sequence of event occurrences in a referenced test 
configuration and with data values and timing constraints. 

<figure><a id="figure-tdl-to-behaviour-example">
<code>
    
    Package TP_RX {
        import all from Sip_Common;
        import all from Diameter_Common;

        Test Purpose {
            TP Id TP_RX_PCSCF_STR_05
            //TP_EPC_7002_21 from ETSI TS 103 029 V5.1.1
            Test objective "Verify that IUT after reception of 486 response sends an ST-Request at originating leg."
            
            Reference 
                "ETSI TS 129 214 (V15.6.0), clauses 4.4.4"
            
            Config Id CF_VxLTE_INT
            
            PICS Selection NONE
            
            Initial conditions with {
                the UE_A entity isAttachedTo the EPC_A and
                the UE_A entity isRegisteredTo the IMS_A
            }
        
            Expected behaviour
                ensure that {
                    when {
                        the IMS_P_CSCF_A entity receives a 486_Response_INVITE
                        from the IMS_S_CSCF_A entity
                    }
                    then {
                        the IMS_P_CSCF_A entity sends the STR containing
                            Session_Id_AVP;
                        to the EPC_PCRF_A entity
                    }
                }  
        }
    }
</code>  
<figcaption style="text-align:center"> <b>Figure 30: TDL-TO behaviour example</b><figcaption>
</figure>
 

A test purpose behaviour example is shown in <a href=#figure-tdl-to-behaviour-example>Figure 30</a> from the test specification 
<a href="https://www.etsi.org/deliver/etsi_ts/103000_103099/103029/05.01.01_60/ts_103029v050101p.pdf" target="_blank">ETSI TS 103 029 V5.1.1</a>. The test purpose behaviour 
references the other parts of a TDL-TO, that is the domain, data and configuration part, that in this example are all imported from the two packages 'SIP_Common' and 'Diameter_Common'.

A test purpose is assigned a unique id often reflecting its association within a test suite structure. In this example indicating in the TP name the 
interface 'RX', the component 'PCSCF', and the message 'STR' relevant for this TP.

The TDL-TO test purpose allows a reference to the base standard from where the requirement and test objective is derived. The test objective may can be 
defined as an informal text string in the field "Test objective". The condition for the applying the test purpose in a test execution can be specified 
in "PICS selection" field. The PICS selection expression may consist of a list of PICS references combined by logical operators.

The test configuration 'CF_VxLTE_INT' referenced in the example specifies the test configuration used in the test behaviour specification part.

The event occurrence sequences of the TDL-TO constitutes the core of the test behaviour part. It is split in three optional parts, the initial condition, 
the expected behaviour, and final conditions. The example illustrates an initial part where the 'UE_A' and 'IMS_A' entities are brought into the state required 
to check the expected behaviour. The events 'isAttachedTo' and 'isRegisteredTo' may be abstract operations which may often be used in the initial phase 
of the TDL TO specification, to allow for further refinements in later phases. In the Expected behaviour part the conditional event occurrence sequences 
are specified that is assigned the verdict of the test purpose, explicitly or implicitly as is the case in this example. The event occurrences in the example 
illustrates the use of undeclared data instances '486_Response_INVITE' and 'STR', where the latter is further specified to contain the data value 
'Session_Id_AVP'. In case the test purpose needs to perform operations after the test objective is achieved, such behaviour may be specified in the final 
conditions part. 

## Transforming Structured Test Objectives into Test Descriptions <a id="sec-transforming-structured-test-objectives-into-test-descriptions"></a>


### Overview


Structured test objectives can be used as a starting point for test descriptions or even for executable test cases. As the abstraction gap between structured 
tests objectives and executable test cases is often too large, it is recommended to refine the structured test objectives into test descriptions in a stepwise 
manner, where at each step there is a smaller abstraction gap in comparison to the preceding step.

While structured test objectives provide many building blocks for a test description, structured test objectives can abstract away many of the important details 
that are essential for the specification of a test description. Some of the details can be inferred easily, while others allow for different interpretations. 
In order to narrow down the spectrum of possible interpretations, it is recommended that guidelines and conventions are defined in advance and enforced during 
the specification of the structured test objectives. This can streamline the refinement process and pave the way for standardized refinement of structured test 
objectives into test descriptions. 

The examples are provided in the textual representation for brevity and convenience. The graphical representation can be used instead as well.

### Data


TDL-TO provides different means for the use of data within a 'StructuredTestObjective'. In addition to the use of defined 'DataIntances' and 'SpecialValueUse's, 
TDL-TO provides means for the specification of literal 'Value's inline, within a 'StructuredTestObjective'.

The use of defined 'DataInstance's and 'SpecialValueUse's does not require particular handling as the same 'DataInstance's can be used in the resulting 
'TestDescription's. While the concrete syntax may be different, the underlying model elements are the same. The corresponding 'DataType's may need to be 
taken into account if a 'TestConfiguration' needs to be inferred from the 'StructuredTestObjective'. Additionally, any qualifying 'Comment's used to describe 
further details related to the context of its usage may need to be interpreted according to the existing conventions (if defined). The example in <a href=#figure-predefined-data-example-in-tdl-to>Figure 31</a> 
illustrates the definition of 'DataType's and 'DataInstance's in TDL-TO. The corresponding data definitions in the textual representation of TDL are shown 
in <a href=#figure-corresponding-data-in-tdl>Figure 32</a>. Apart from minor syntactical differences, the underlying model structures are the same. In fact, the TOP tools enable cross referencing between 
both notations so that data definitions in TDL can be reused in TDL-TO and vice-versa.

<figure><a id="figure-predefined-data-example-in-tdl-to">
<code>
    
    Package data {
      Data {
        type float;
        type position with x of type float, y of type float;
        float -22; 
        float -21; 
        position startingPosition containing x indicating value -21;
      } 	
    }
</code>    
<figcaption style="text-align:center"> <b>Figure 31: Predefined data example in TDL-TO</b> </figcaption>
</figure>


<figure><a id="figure-corresponding-data-in-tdl">
<code>
    
    Package data {
      Type float ;
      Type position ( x of type float , y of type float ) ;
      float -22 ;
      float -21 ;
      position startingPosition ( x = -21 ) ;
    }
</code>
<figcaption style="text-align:center"> <b>Figure 32: Corresponding data in TDL</b></figcaption>
</figure>


TDL-TO permits the use of 'LiteralValue's as a flexible way for specifying the arguments of 'EventOccurrenceSpecification's. This can be useful, especially 
at an early stage, where the data structures and contents are not fixed yet. 'LiteralValue's may contain descriptions of the structure and contents of the 
'LiteralValue'. Additionally, 'LiteralValue's may be referenced within the same 'StructuredTestObjective'. Any qualifying 'Comment's used to describe further 
details related to the context of its usage may need to be interpreted according to the existing conventions (if defined).

In order to transform 'LiteralValue's, first corresponding 'DataType's and 'DataInstance's need to be inferred. Consider the following example illustrated 
in <a href=#figure-literal-data-in-tdl-to>Figure 33</a>, showing a 'LiteralValue' specification within an 'EventOccurrenceSpecification'. The basic structure is the same, but there are no predefined 
'DataType's and 'DataInstance's. The inferred 'DataType's and 'DataInstance's are illustrated in <a href=#figure-inferred-literal-data-in-tdl>Figure 34</a>. The inferred 'DataElement's are prefixed 
with 'inferred_' for illustrative purposes. The contextual information may provide hints for more appropriate naming. Apart from the inference, type compatibility 
and merging needs to be considered. In this example, it is assumed that 'x' and 'y' are of the same type, otherwise distinct 'DataType's need to be inferred 
as well. If a 'StructuredDataInstance' is used only once, it is also possible to specify it as inline 'DataInstanceUse' in TDL.


<figure><a id="figure-literal-data-in-tdl-to">
<code>
    
    when { 
        the Controller entity sends the start position containing 
          x indicating value 22,
          y indicating value 21
      ; 
    } then {
        the Object entity moves_to the received start position
    } 
</code>
<figcaption style="text-align:center"> <b>Figure 33: Literal data in TDL-TO</b></figcaption>
</figure>


<figure><a id="figure-inferred-literal-data-in-tdl">
<code>
    
    Package inferred_data {
      Type inferred_simple ;
      Type inferred_position ( x of type inferred_simple, y of type inferred_simple) ;
      inferred_simple 22 ;
      inferred_simple 21 ;
      inferred_position inferred_start_position ( x = 22, y = 21 ) ;
    }
</code>
<figcaption style="text-align:center"> <b>Figure 34: Inferred literal data in TDL</b></figcaption>
</figure>


In case existing 'DataInstance's are used and corresponding 'DataMapping's exist, these can be reused as well. Otherwise, the 'DataMapping's can be 
defined as part of the refinement process for both existing data specifications and data specifications inferred from inline literal data specifications.

### Configurations


Similar to the use of data, TDL-TO provides different means for the specification of the entities related to an 'EventOccurrenceSpecification'. Abstract 
entities can be useful, especially at an early stage, where the 'TestConfiguration's are not fixed yet. If 'TestConfiguration's are already specified, 
the corresponding 'ComponentInstances' can be used in 'EventOccurrenceSpecification's. An example for a simple 'TestConfiguration' and corresponding 
'ComponentType's and 'GateType's specified in TDL-TO is shown in <a href=#figure-predefined-configuration-example-in-tdl-to>Figure 35</a>. The corresponding definitions in the textual representation of TDL are 
shown in <a href=#figure-corresponding-configuration-in-tdl>Figure 36</a>. The use of defined 'ComponentInstance's does not require particular handling as the same 'TestConfiguration's can be used in 
the resulting 'TestDescription's. Apart from minor syntactical differences, the underlying model structures are the same. The TOP tools enable 
cross referencing between both notations so that definitions related to 'TestConfiguration's in TDL can be reused in TDL-TO.


<figure><a id="figure-predefined-configuration-example-in-tdl-to">
<code>
    
    Package base_configuration {
      import all from data;
      Configuration {
        Interface Type wireless accepts position;
        Component Type unit with gate wifi of type wireless;
        Test Configuration basic containing 
          Tester component controller of type unit 
          SUT component object of type unit
          connection between controller.wifi and object.wifi
        ; 
      }
    }
</code>
<figcaption style="text-align:center"> <b>Figure 35: Predefined configuration example in TDL-TO</b></figcaption>
</figure>


<figure><a id="figure-corresponding-configuration-in-tdl">
<code>
    
    Package base_configuration {
      Import all from data ;
      Gate Type wireless accepts position ;
      Component Type unit having {
        gate wifi of type wireless ;
      }
      Test Configuration basic {
        create Tester controller of type unit ;
        create SUT object of type unit ;
        connect controller.wifi to object.wifi ;
      }
    }
</code>
<figcaption style="text-align:center"> <b>Figure 36: Corresponding configuration in TDL</b></figcaption>
</figure>


The use of abstract entities provides more flexibility early on, however, it requires clear guidelines and conventions for the interpretation of the abstract 
entities. An 'Entity' may be transformed into a 'ComponentInstance' or a 'GateInstance' depending on the intended interpretation. Hints and conventions regarding 
the desired interpretation of an 'Entity' can be provided in the 'Entity' definition, in the context of its use, or outside the TDL-TO specification. 
Considering the example illustrated in <a href=#figure-literal-data-in-tdl-to>Figure 33</a>, it can be inferred that the 'Controller' entity and the 'Object' entity have some means to interact without 
this being explicitly specified. <a href=#figure-inferred-configuration-in-tdl>Figure 37</a> illustrates one possible 'TestConfiguration' which can be inferred from the 
behaviour specification in <a href=#figure-literal-data-in-tdl-to>Figure 33</a>. 
First, one or more 'GateType's need to be inferred, then the corresponding 'ComponentType's and their 'GateInstance's. For simplicity, it is assumed that 'Controller' 
and 'Object' are of the same 'ComponentType', conventions may be put in place to indicate that. Alternatively, subsequent refinement may further differentiate the 
'ComponentType's where appropriate. Finally, the 'TestConfiguration' is inferred, including assigning 'ComponentInstance's with corresponding roles, as well as 
'Connection's between the inferred 'GateInstance's. In this example, the roles and 'Connections' are inferred based on the 'EventOccurrenceSpecification's and their 
context (e.g. when/then clauses, etc.). Similar to 'DataType's, compatible inferred 'TestConfiguration's, 'ComponentType's, and 'GateType's need to be identified and 
merged where applicable to avoid unnecessary duplication.


<figure><a id="figure-inferred-configuration-in-tdl">
<code>
    
    Package inferred_configuration {
      Import all from data 
      Gate Type inferred_gate_type accepts inferred_position ;
      Component Type inferred_component_type having {
        gate inferred_gate of type inferred_gate_type ;
      }
      Test Configuration inferred_move_object {
        create Tester Controller of type inferred_component_type ;
        create SUT Object of type inferred_component_type ;
        connect Controller.inferred_gate to Object.inferred_gate ;
      }
    }
</code>
<figcaption style="text-align:center"> <b>Figure 37: Inferred configuration in TDL</b></figcaption>
</figure>



### Behaviour


Initial conditions, expected behaviour, and final conditions in TDL-TO are expressed by means of 'EventSequences'. 'EventSequences' are comprised of 
'EventOccurrenceSpecification's. This provides simple generic high-level construct with loose semantics indicated by the referenced 'Event'. The 
interpretation of the 'Event' can be indicated in the domain description and/or refined in the 'EventOccurrenceSpecification'. It is recommended to establish 
well-defined specification conventions in order to ensure consistent interpretation. TDL 'TestDescriptions' require more differentiated specification of 
behaviour, distinguishing between 'Interaction's, 'Action's, and other kinds of 'Behaviour's. While some assumptions regarding the mapping of 'Event's to 
'AtomicBehaviour's can be made intuitively, it is recommended to define explicit conventions in order to ensure consistent interpretation and transformation. 
The example in <a href=#figure-expected-behaviour-specification-in-tdl-to> Figure 38</a> illustrates a minimal 'StructuredTestObjective' containing only the specification of the expected behaviour. Assuming the data 
and configuration related information has been inferred as illustrated in the previous examples, the corresponding 'TestDescription' inferred from the 
'StructuredTestObjective' is shown in <a href=#figure-corresponding-behaviour-specification-in-tdl> Figure 39</a>. In this scenario, the first 'EventOcurrenceSpecification' in the 'whenClause' is interpreted as an 
'Interaction' between the 'Controller' and the 'Object', the latter is assumed to be the implicit opposite entity in the 'EventOcurrenceSpecification'. 
It is recommended to make opposite entities explicit whenever possible. The second 'EventOcurrenceSpecification' in the 'thenClause' is interpreted as an 
'ActionReference'. In this case, it is also necessary to infer a definition for the action.


<figure><a id="figure-expected-behaviour-specification-in-tdl-to">
<code>
    
    Test Purpose {   
        TP Id TP_MOVE_OBJECT_LITERAL
        Test objective "Move object to destination with literal values."
        Expected behaviour 
        ensure that {
            when { 
                the Controller entity sends the start position containing 
                  x indicating value 22,
                  y indicating value 21
              ; 
            } then {
                the Object entity moves_to the received start position
            } 
        }
    }
</code>
<figcaption style="text-align:center"> <b>Figure 38: Expected behaviour specification in TDL-TO</b></figcaption>
</figure>


<figure><a id="figure-corresponding-behaviour-specification-in-tdl">
<code>
    
    Action move_to (position of type inferred_position);
    Test Description TD_MOVE_OBJECT_LITERAL uses configuration inferred_move_object {
      Controller.inferred_gate sends inferred_start_position to Object.inferred_gate;
      perform action move_to (position = inferred_start_position) on Object;
    }
</code>
<figcaption style="text-align:center"> <b>Figure 39: Corresponding behaviour specification in TDL</b></figcaption>
</figure>

If desired, especially when 'StructuredDataInstance's are used only once, it is also possible to specify them as inline 'DataInstanceUse's in TDL. The resulting 
'TestDescription' for the example in <a href=#figure-expected-behaviour-specification-in-tdl-to> Figure 38</a> is shown in 
<a href=#figure-corresponding-behaviour-specification-in-tdl-using-inline-data> Figure 40</a>, where instead of the 'inferred_start_position' 'DataInstance', the corresponding 
data is specified inline. Since the 'DataInstance' is used twice in this case, it results in some duplication.


<figure><a id="figure-corresponding-behaviour-specification-in-tdl-using-inline-data">
<code>
    
    Action move_to (position of type inferred_position);
    Test Description TD_MOVE_OBJECT_LITERAL_INLINE uses configuration inferred_move_object {
      Controller.inferred_gate sends new inferred_position (x = 22, y = 21) to Object.inferred_gate;
      perform action move_to (position = new inferred_position (x = 22, y = 21)) on Object;
    } 
</code>
<figcaption style="text-align:center"> <b>Figure 40: Corresponding behaviour specification in TDL using inline data</b></figcaption>
</figure>


The steps for the derivation of 'TestDescription's from 'StructuredTestObjective's can be translated to other notations as well. Fundamentally, the process 
remains the same, starting with the data definitions, through the test configurations, and finally the behaviour specifications. The above guidelines can be 
used as a template for deriving 'TestDescription's from other kinds of documents and artifacts as a starting point.

### Transformation Conventions and Assumptions


The transformation of 'LiteralValue's involves the following conventions:

 - If the 'Content' of the 'LiteralValue' is empty, the 'LiteralValue' is mapped to a 'SimpleDataType' with a 'name' corresponding to the 'name' of the 'LiteralValue'. 
   If qualifier 'Comment's are present, a 'SimpleDataInstance' is created with a 'name' corresponding to the concatenated 'bodies of the qualifier 'Comment's. 
   Alternatively, the 'name' of the 'DataType' can also be prefixed with the concatenated 'bodies of the qualifier 'Comment's. If the corresponding 'DataType' or 
   'DataInstance' exists, no action is taken.
   
 - If the 'Content' of the 'LiteralValue' is not empty, the 'LiteralValue' is mapped to a 'StructuredDataType' with a 'name' corresponding to the 'name' of the 
   'LiteralValue'. If qualifier 'Comments are present, a 'StructuredDataInstance' is created with a 'name' corresponding to the concatenated 'bodies of the qualifier 
   'Comment's. Alternatively, the 'name' of the 'DataType' can also be prefixed with the concatenated 'bodies of the qualifier 'Comment's. If the corresponding 
   'DataType' or 'DataInstance' exists, no action is taken.
   
 - Each 'Content' element of the 'LiteralValue' is mapped to a 'Member' within the corresponding 'StructuredDataType' with a 'name' corresponding to the 'name' of 
   the 'Content'. If a 'Member' with the same 'name' exists, no action is taken. The 'DataType' of the 'Member' corresponds to:
   
    -	A new 'DataType' corresponding to the 'Content' with a 'name' prefixed with the 'name' of the containing 'StructuredDataType' in case a 'Content' 
      is directly contained within the 'Content'.
      
    -	A (default) 'SimpleDataType' corresponding to the 'LiteralValue' in case a 'LiteralValue' is directly contained within the 'Content'.
    
    -	The 'DataType' corresponding to the 'dataType' of the 'DataInstanceUse' in case a 'DataReference' is directly contained within the 'Content'.
    
 - Each nested 'Content' or 'LiteralValue' element is transformed according to the conventions above.
 
For example, as shown in <a href=#figure-literalvalues-and_datareferences-example> Figure 41</a> and 
<a href=#figure-resulting-datatype-specifications-in-tdl> Figure 43</a>, for the 'EventOccurrenceSpecification' taken from 
<a href="https://www.etsi.org/deliver/etsi_ts/103500_103599/10359702/01.01.01_60/ts_10359702v010101p.pdf" target="_blank">ETSI TS 103 597-2: MTS, Test Specification for MQTT, Part 2: Security Tests</a>, 
a corresponding 'StructuredDataType' is 
created for both the 'LiteralValue' 'message' and for the 'payload' 'Content' of the 'message'. The 'dataType' for the 'payload' 'Member' is then set accordingly. 
Instead, since the 'value's for the 'filterLength' and 'topic_filter' Content's correspond to 'DataReference's to defined 'DataInstance's, as shown in 
<a href=#figure-corresponding-datainstance-definitions> Figure 42</a>, 
the 'dataType's for the corresponding 'Member's in the derived 'SUBSCRIBE_message_payload' 'DataType' are: set to the 'dataType's of the referenced 'DataInstance's.


<figure><a id="figure-literalvalues-and_datareferences-example">
<code>
    
      the IUT entity receives a SUBSCRIBE message containing
        payload containing
           filterLength corresponding to TOPIC_FILTER_LEN_SEC_CVE_01,
           topic_filter corresponding to TOPIC_FILTER_SEC_CVE_01;;
      from the ATTACKER_CLIENT entity
</code>
<figcaption style="text-align:center"> <b>Figure 41: 'LiteralValue's and 'DataReference's example</b></figcaption>
</figure>


<figure><a id="figure-corresponding-datainstance-definitions">
<code>
    
      Data {
        UTF8String TOPIC_FILTER_SEC_CVE_01;  // topic filter used in TP_MQTT_BROKER_SEC_CVE_001
        Int16 TOPIC_FILTER_LEN_SEC_CVE_01;   // corresponds to lengthof(TOPIC_FILTER_SEC_CVE_01) + 1
      }
</code>
<figcaption style="text-align:center"> <b>Figure 42: Corresponding 'DataInstance' definitions </b></figcaption>
</figure>

<figure><a id="figure-resulting-datatype-specifications-in-tdl">
<code>
    
      Type SUBSCRIBE_message (
        payload of type SUBSCRIBE_message_payload
      ) ;
      Type SUBSCRIBE_message_payload (
        filterLength of type Int16 ,
        topic_filter of type UTF8String
      ) ;
</code>
<figcaption style="text-align:center"> <b>Figure 43: Resulting 'DataType' specifications in TDL</b></figcaption>
</figure>

For the transformation of 'EventOccurrence's into 'Behaviour's, it is necessary to first derive the corresponding 'TestConfiguration' if no 'TestConfiguration' 
is specified for the 'StructuredTestObjective'. The derivation of the 'TestConfiguration' involves the following conventions:

 - Each 'EntityReference' is transformed a 'ComponentType' and a 'GateType', where the 'GateType' accepts the 'DataType's resulting from the transformation of 
   the 'LiteralValue's specified as arguments of the 'EventOccurrence'. The 'ComponentType' contains a 'GateInstance' of the transformed 'GateType'. If the 
   'ComponentType', 'GateType', or 'GateInstance' already exists, no action is taken.
   
 - A 'TestConfiguration' is constructed with 'ComponentInstance's of the 'ComponentType's resulting from the transformation above. It is recommended to use naming 
   conventions, annotations, or other conventions to indicate the roles of the 'ComponentInstance's, otherwise the roles are set to a default value of 'Tester' 
   or 'SUT' and need to be adjusted afterwards. While opposite 'EntityReference's are optional, it is recommended that they are explicitly specified, otherwise an 
   implicit 'Tester' 'ComponentInstance' needs to be assumed and constructed. If the assumption of an implicit 'Tester' does not hold, the transformed 'TestConfiguration' 
   may need to be adjusted.
   
 - Within the 'TestConfiguration', 'Connection's need to be created between interacting 'ComponentInstance's for every 'EventOccurrence'. If a 'Connection' already 
   exists, no action is taken.
   
 - Conventions or comparison between 'TestConfiguration's are recommended to avoid duplicate identical configurations.
   Once a suitable 'TestConfiguration' is derived, 'EventOccurrence's can be transformed into 'Behaviour's. There can be different strategies, ranging from 
   transforming 'EventOccurrence's into detailed 'Interaction's, to transforming 'EventOccurrence's into abstract 'TestDescription' skeletons as containers for 
   manually specified 'Behaviour's. This may depend on the general test specification process and/or the level of detail of the structured test objective specifications. 
   Assuming detailed 'Message's as the target, the following conventions can be applied:
   
 - A 'TestDescription' using the 'TestConfiguration' resulting from the transformation above is constructed as a container for the 'Behaviour's. For traceability and 
   in general, it is recommended that the 'TestDescription' references the 'StructuredTestObjective' as its 'testObjective'.
   
 - In the simplest case, the 'TestDescription' contains one 'CompoundBehaviour' which contains the individual 'Behaviour's corresponding to the 'EventOccurrence's.
 
 - If desired, the 'CompoundBehaviour' may contain further 'CompoundBehaviour's corresponding to the structural blocks of the 'StructuredTestObjective', e.g. 
   "Initial conditions", "Expected behaviour", "when/then"-clauses, etc., so that the resulting 'TestDescription' more closely reflects the structure of the corresponding 
   'StructuredTestObjective'. The additional 'CompoundBehaviour's may be annotated to clearly specify their purpose and potentially also influence how tools represent or 
   treat the individual 'Behaviour's within the additional 'CompoundBehaviour's.
   
 - The individual 'EventOccurrence's are transformed into corresponding 'Behaviour's. In the absence of further information, it needs to be specified what the default 
   'Behaviour' should be. In general, suitable conventions and 'Annotation's are recommended to ensure easier transformation. Assuming that the target 'Behaviour' is a 
   'Message', a 'Message' is constructed with the source and target 'GateReference's corresponding to the 'EntityReference's of the 'EventOccurrence'. The assumptions 
   for the transformation of 'TestConfiguration's apply in this case as well, particularly when no opposite 'EntityReference' is specified. A 'DataUse' is then constructed 
   as the argument of the 'Message' based on the 'LiteralValue' specified as the argument of the 'EventOccurrence' and the 'DataType's resulting from the transformation above.


   
## Defining Test Descriptions  <a name="sec-defining-test-descriptions"></a>


### Overview


In the absence of structured test objectives or other documents which can serve as a starting point, test descriptions can be defined from scratch. The fundamental steps 
in the process involve the definition of data first, then configurations, finally the behaviour. The following examples illustrate the different steps by means of the 
graphical syntax for TDL with the help of the graphical editor.

### Data and Configuration

Since the 'Generic TDL' diagram accommodates both the specification of data- and configuration-related elements, both are contemplated together. If necessary, separate 
diagrams can be created instead to capture only data-related or configuration-related elements separately. In the example shown in 
<a href=#figure-data-and-configuration-specification-in-tdl-using-the-graphical-editor>Figure 44</a> the one diagram approach 
is shown for conciseness and also to show a complete overview of all relevant elements in one place. On the top-left side the predefined simple data types are shown. 
In the bottom part the verdict-related types and instances are shown. On the right side behaviour-related definitions for an 'Action' and a 'TestDescription' are shown. 
Finally, in the middle part, the data types, data instances, as well as component and gate types and the test configuration are shown. The graphical editor does provide 
some more flexibility with regard to the order of creation of the different elements. However, the fundamental order remains the same - data, configuration, behaviour.
 

<figure style="margin-left:auto; margin-right:auto; width:50%"><a id="figure-data-and-configuration-specification-in-tdl-using-the-graphical-editor"></a>
<img src="images/DataAndConfSpecInTdlGr.png" alt="Data and configuration specification in TDL using the graphical editor">
<figcaption style="text-align:center; font-weight:bold">Figure 44: Data and configuration specification in TDL using the graphical editor</figcaption>   
</figure>
 

### Test Behaviour and Time


The 'TDL Behaviour' diagram allows the visualization and specification of the behaviour of an individual 'TestDescription'. While the 'TestDescription' itself is 
defined within a 'Generic TDL' diagram, including its name, parameters, test configuration, and test objectives, the specifics of the behaviour are shown in a separate 
'TDL Behaviour' diagram. The example shown in <a href=#figure-test-behaviour-in-tdl-using-the-graphical-editor>Figure 45</a> illustrates 
the behaviour of the 'TD_MOVE_OBJECT' 'TestDescription'. In addition to the basic behaviour, 
temporal properties of the behaviour are illustrated with the help of a 'TimeLabel' and a 'TimeConstraint'.


<figure style="margin-left:auto; margin-right:auto; width:35%"><a id="figure-test-behaviour-in-tdl-using-the-graphical-editor"></a>
<img src="images/TestBehaviourInTdlInGrFormat.png" alt="Test behaviour in TDL using the graphical editor">
<figcaption style="text-align:center; font-weight:bold">Figure 45: Test behaviour in TDL using the graphical editor</figcaption>   
</figure>
 


'TestDescriptionReference's enable the reuse of behaviour definitions. While in some other high-level test specification languages the use of so-called "data tables" 
has been gaining some popularity, TDL provides more sophisticated facilities both for the definition of data and for the reuse of behaviour. A parameterized 
'TestDescription' can be invoked multiple times with different data instances as shown in the example in <a href=#figure-test-behaviour-reuse-in-tdl-using-test-description-references>Figure 46</a>.
In the 'TC_MOVE_AROUND' 'TestDescription', the 'TC_MOVE_TO' 'TestDescription is invoked four times to describe a test sequence where the 'Object' needs to move to four positions.


<figure><a id="figure-test-behaviour-reuse-in-tdl-using-test-description-references"></a>
<code>
    
    Test Description TC_MOVE_TO (target_position of type inferred_position) 
    uses configuration inferred_move_object {
      Controller.inferred_gate sends parameter target_position to Object.inferred_gate;
      perform action move_to (position = parameter target_position) on Object;
    }	

    Test Description TC_MOVE_AROUND 
        uses configuration inferred_move_object {
      execute TC_MOVE_TO (target_position = start_position);
      execute TC_MOVE_TO (target_position = open_position);
      execute TC_MOVE_TO (target_position = closed_position);
      execute TC_MOVE_TO (target_position = end_position);
    }	
</code>
<figcaption style="text-align:center"> <b>Figure 46: Test behaviour reuse in TDL using test description references</b></figcaption>
</figure>


## Transforming Test Descriptions into TTCN-3 Test Cases<a id="sec-transforming-test-descriptions-into-ttcn-3-test-cases">


### Overview


One way to obtain executable test cases from TDL is to transform the test descriptions into TTCN-3 code. The standardized mapping to TTCN-3 in 
<a href="https://www.etsi.org/deliver/etsi_es/203100_203199/20311906/01.03.01_60/es_20311906v010301p.pdf" target="_blank">ETSI ES 203 119-6</a> 
specifies in great detail all the peculiarities that need to be considered for the derivation of executable test cases in TTCN-3 from TDL. The basic steps remain fundamentally 
the same, involve transforming the data definitions, the configuration-related definitions, as well as the behaviour specifications. All the transformations have to take 
into account the semantic gaps between both languages, as well as the intrinsic differences in the levels of abstraction. The standardized mapping is defined for locally 
ordered test descriptions only. Thus, if totally ordered test descriptions are the starting point, these first need to be transformed into locally ordered test descriptions, 
keeping in mind the differences in semantics and the additional constraints that are imposed by locally ordered test descriptions. The prototypical implementation of the 
mapping within the TOP provides automated translation for the essential parts necessary for the transformation of TDL 'TestDescription's to TTCN-3 test cases.

### Data


To illustrate the mapping of the data-related elements, consider the example in <a href=#figure-test-data-example-in-tdl>Figure 47</a>. It illustrates different data definitions and data uses. The corresponding 
equivalents in TTCN-3 are shown in <a href=#figure-test-data-equivalents-in-ttcn-3-for-preceding-figure>Figure 48</a>. The mappings for data are pretty straightforward in this example. Although the use of data mappings is recommended, 
in which case the respective mapping targets are used instead, it is also possible to generate basic data definitions in case no data mappings are present. 
Annotations

<figure><a id="figure-test-data-example-in-tdl"></a>
<code>
     
        //data types
        Type SESSIONS (id1 of type Integer, id2 of type Integer);
        Type MSG (ses of type SESSIONS, content of type String);
    
        //data instances
        SESSIONS s1(id1 = 1, id2 = 2);
        SESSIONS s2(id1 = 11, id2 = 22); 
        MSG msg1(ses = s1, content = m1);
    
        //value data instances
        SESSIONS c_s1(id1 = 1, id2 = 2) with {VALUE;}; 
        MSG c1(ses = s1, content = c1) with {VALUE;};
    
        Component Type ct having {
            //variables
            variable v1 of type MSG with {VALUE;};
            variable v2 of type MSG;
            gate g of type gt;
        }
</code>
<figcaption style="text-align:center"> <b>Figure 47: Test data example in TDL</b></figcaption>
</figure>


<figure><a id="figure-test-data-equivalents-in-ttcn-3-for-preceding-figure">
<code>
    
        //data types
        type record SESSIONS { 
            integer id1,
            integer id2
        }
        type record MSG { 
            SESSIONS ses, 
            charstring content
        }
        
        //templates
        template SESSIONS s1 := {id1:=1, id2:=2} 
        template SESSIONS s2 := {id1:=11, id2:=22} 
        template MSG msg1 := {ses := s1, content := "m1"}
        
        //value -> constant
        const SESSIONS c_s1 := {id1:=1, id2:=2}
        const MSG c1 := {ses := c_s1, content := "c1"} 
    
        type component ct {
            //variables
            var MSG v1;
            var template MSG v2;
            port gt g;
        }
</code>
<figcaption style="text-align:center"> <b>Figure 48: Test data equivalents in TTCN-3 for preceding figure</b></figcaption>
</figure>


### Configuration


With regard to test configurations, there are several concerns to address. TTCN-3 provides means for the dynamic instantiation and management of test configurations. 
The essential parts of a configuration include the main test component which plays a special role, zero or more parallel test components, as well as a unified system 
interface. There is a distinction between connecting and mapping ports and there are some restrictions with regard to these. In TDL the test configuration is defined 
upfront and remains static. TDL also provides a holistic view where the SUT can be decomposed into multiple interconnected components.
The example in <a href=#figure-test-configuration-example-in-tdl>Figure 49</a> illustrates a minimal test configuration in TDL. The corresponding mapping in TTCN-3 is 
illustrated in <a href=#figure-test-configuration-related-equivalents-in-ttcn-3-for-preceding-figure>Figure 50</a>. A unified system interface needs to be inferred 
in case there are multiple SUT components. The steps for instantiating and mapping/connecting the components are encapsulated in a function.

<figure><a id="figure-test-configuration-example-in-tdl">
<code>
    
        Gate Type defaultGT accepts 
            ACK, PDU, PDCCH, C_RNTI, CONFIGURATION ;
    
        Component Type defaultCT having {
	        gate g of type defaultGT;
        }
    
        Test Configuration defaultTC {
	        create Tester SS of type defaultCT;
	        create SUT UE of type defaultCT ;
	        connect UE.g to SS.g ;
        }
</code>
<figcaption style="text-align:center"> <b>Figure 49: Test configuration example in TDL</b></figcaption>
</figure>



<figure><a id="figure-test-configuration-related-equivalents-in-ttcn-3-for-preceding-figure">
<code>
    
    type port defaultGT_to_map message {  
      //this is a port type for SUT-Tester connections
      inout charstring, PDCCH /* ACK, PDU, C_RNTI, CONFIGURATION ; */  
    }  
    
    type port defaultGT_to_connect message { 
      //this is a port type for Tester-Tester connections 
      inout charstring, PDCCH /* ACK, PDU, C_RNTI, CONFIGURATION ; */  
    }
    
    type component MTC_CT { 
      //component type for MTC
      //variable for the PTC(s) --TESTER component(s) in TDL
      var defaultCT TESTER_SS; 
    }
      
    type component defaultCT { 
      port defaultGT_to_map g_to_map;
      port defaultGT_to_connect g_to_connect;
    }
    
    function defaultTC() runs on MTC_CT { 
      // Test Configuration defaultTC, mappings, connections
      TESTER_SS := defaultCT.create;
      map (TESTER_SS:g_to_map,system:g_to_map);
    }
</code>
<figcaption style="text-align:center"> <b>Figure 50: Test configuration related equivalents in TTCN-3 for preceding figure </b></figcaption>
</figure>


###  Behaviour


In terms of behaviour, TTCN-3 and TDL also have different assumptions. In TTCN-3, the focus is on the test system view, where all components execute their behaviour 
concurrently and independently unless there is explicit synchronization among them. TDL aims to provide a global view with the possibility to specify both locally and 
totally ordered behaviour, with explicit or implicit synchronization respectively. For the standardized mapping to TTCN-3 only the local ordering is taken into consideration. 
User-defined mappings may also tackle the totally ordered behaviour. In the example shown in <a href=#figure-test-behaviour-example-in-tdl>Figure 51</a>
a locally ordered 'TestDescription' is illustrated. The 
corresponding mappings in TTTCN-3 are shown in <a href=#figure-required-altstep-definitions-in-ttcn-3>Figure 52</a>, 
<a href=#figure-behaviour-mapping-in-ttcn-3-for-preceding-test-behaviour-example>Figure 53</a>, and 
<a href=#figure-test-case-integrating-all-steps-for-mapping-to-ttcn-3-the-preceding-test-behaviour-example>Figure 54</a>. First, the default handling needs to be taken care of. This involves the definition 
of altsteps to handle deviations from the specified behaviour as well as quiescence, which is illustrated in <a href=#figure-required-altstep-definitions-in-ttcn-3>Figure 52</a>. 
Then the actual test behaviour from the 
test system's point of view is translated to a function as illustrated in <a href=#figure-behaviour-mapping-in-ttcn-3-for-preceding-test-behaviour-example>Figure 53</a>. 
Finally, in <a href=#figure-test-case-integrating-all-steps-for-mapping-to-ttcn-3-the-preceding-test-behaviour-example>Figure 54</a> a test case is defined which takes care of activating 
the default behaviour, instantiating the test configuration, as well as starting the actual test behaviour.

<figure><a id="figure-test-behaviour-example-in-tdl">
<code>
    
    Test Description Implementation TD_7_1_3_1
      uses configuration defaultTC {
        
      SS.g sends pdcch (c_rnti=ue) to UE.g;
      SS.g sends mac_pdu to UE.g;
      UE.g sends harq_ack to SS.g with {
        test objectives : TP1 ;
      };
    
      set verdict to PASS ;
      SS.g sends pdcch (c_rnti=unknown) to UE.g;
      SS.g sends mac_pdu to UE.g;
    
      alternatively {
        UE.g sends harq_ack to SS.g ;
          set verdict to FAIL ;
      } or {
          gate SS.g is quiet for five ;
        set verdict to PASS ;
      } with {
            test objectives : TP2 ;
      }
    }
</code>
<figcaption style="text-align:center"> <b>Figure 51: Test behaviour example in TDL</b></figcaption>
</figure>


<figure><a id="figure-required-altstep-definitions-in-ttcn-3">
<code>
    
    altstep to_handle_deviations_from_TDL_description_AS () {
      [] any port.receive {
        setverdict(fail);
        mtc.stop;
      }
      //if nothing happens, a timer is started  
      //before every receive instruction 
      //and the timer is here
      //or we can leave the timeout for 
      //the execute instruction called with the optional 
      //timer parameter - but in this case 
      //the final verdict will be 'error'
    }
    
    altstep quiescence_handler_AS (timer quiescence) { 
      //for all quiescence that is not connected to a gate
      [] any port.receive{ 
         setverdict(fail);
         mtc.stop;
      }
      [] quiescence.timeout {  
         setverdict(pass);
      }
    }
</code>
<figcaption style="text-align:center"> <b>Figure 52: Required altstep definitions in TTCN-3</b></figcaption>
</figure>


<figure><a id="figure-behaviour-mapping-in-ttcn-3-for-preceding-test-behaviour-example">
<code>
    
    function behaviourOfTESTER_SS() runs on defaultCT {
      timer quiescence;
      activate(to_handle_deviations_from_TDL_description_AS());
     
      g_to_map.send(modifies pdcch := {c_rnti := ue}) 
      g_to_map.send(mac_pdu); 
      g_to_map.receive(harq_ack);
      setverdict(pass);
      /*Test Objective Statisfied:  TP2 */                      
      
      g_to_map.send(modifies pdcch := {c_rnti := unknown}); 
      g_to_map.send(mac_pdu);
    
      quiescence.start(five);
      alt{
        [] g_to_map.receive(harq_ack){
           setverdict(fail);
        }
        [] quiescence_handler_AS(quiescence);
        /*Test Objective Statisfied:  TP2 */                      
      }             
    }
</code>
<figcaption style="text-align:center"> <b>Figure 53: Behaviour mapping in TTCN-3 for preceding test behaviour example</b></figcaption>
</figure>


<figure><a id="figure-test-case-integrating-all-steps-for-mapping-to-ttcn-3-the-preceding-test-behaviour-example">
<code>
    
    testcase TD_7_1_3_1() runs on MTC_CT 
      system defaultCT
    {
      activate(to_handle_deviations_from_TDL_description_AS());
      defaultTC();
      TESTER_SS.start(behaviourOfTESTER_SS());   
      all component.done;
    }
</code>
<figcaption style="text-align:center"> <b>Figure 54: Test case integrating all steps for mapping to TTCN-3 the preceding test behaviour example</b></figcaption>
</figure>


