The open source implementation is based on the Eclipse Modelling Framework, XText, Epsilon, and Sirius to provide a set of Java libraries and Eclipse plugins to support development of TDL specifications.

## Setup

See the README information for instructions on how to set up a local development environment.

## Build Automation

Apache Maven is used for build automation so that the plug-ins can be built without installing and setting up Eclipse. However, having Eclipse set up is useful to quickly detect obvious issues and test any changes. Tycho is used to orchestrate the Eclipse plugin dependency resolution.

The components are organised in respective subfolders, including:

 - plugins - individual plug-ins providing specific functionality
 - features - aggregate features combining clients into sets of functionality
 - updatesite - destination were an update site is set up with the built artifacts that can then be used for public deployment or for local installations
 - org.etsi.mts.tdl.parent - parent project which sets up common build settings and dependencies which are reused for the individual projects as well as the target platform definition

To build all components, `mvn clean package` or `mvn clean install` in the `org.etsi.mts.tdl.parent` folder is sufficient.

For individual components `mvn package install -pl ../plugins/PLUGIN_FOLDER` can be used, e.g. `org.etsi.mts.tdl.model`. For features, the path needs to be updated. Cleaning may be needed as well. The `-am` option also builds required projects. The `-o` uses offline mode which may be faster for repeated runs, but will likely fail if dependencies have changed. For further information, consult the Maven documentation.

Apart from the update site for some plug-ins, there might also be other artifacts, for example, the standalone plug-in and the runtime plug-in. They can be found in the respective target folders.

In case plug-in dependencies have been updated, it is important to check that the target platform definition is also up-to-date. Direct maven dependencies are rarely used and should generally not need many updates. Plugin dependencies are generally defined in the plugin manifests, so that there is no difference between building in Eclipse and building with Maven. Maven builds should work in Eclipse as well, however, having the automated build activated in Eclipse at the same time as a Maven build outside Eclipse can cause some issues. In that case, builds shall be run only within Eclipse or the automated builds shall be (temporarily) deactivated.

## Build Pipelines

A build pipeline has been set up on the GitLab. It performs the basic build tasks and publishers the results as packages and releases, including permanent link to the latest release. The pipeline is triggered when changes are pushed to the designated branch and the results published in the permanent link are overwritten. The pipeline can also be triggered through the web interface, and on a schedule (once a week). Every time the pipeline is executed, a new tag is created. To access older versions, refer to the packages and releases which include respective links to the snapshots. Snapshots may not be available after a period of time.

The pipeline makes use of some configurations variables that are reused throughout the pipeline. It also includes some Maven configurations, including a cache to speed up the build process.

Currently the pipeline, includes four stages.

 - build - execute the Maven build (exposes the resulting artifacts)
 - prepare - update variables to configure release
 - upload - publish archive of built artifacts as a GitLab package, setup and publish GitLab page with update site artifacts as a permanent link to the latest build
 - release - publish a release with information and links on GitLab

Automated tests and checks, as well as publishing other artifacts, may be added to the pipeline at a later point. Note that a package is currently limited to about 100 MB.

For further details, look into the pipeline configuration.

### How to contribute

See [contributor information](How-to-contribute)