# Creating a new TDL project

From the file menu select New and in the sub-menu select Project. In the New Project dialog box select either the 
TDL or TDLtx option to create either a TDL model using the TDL graphical notation or textual notation respectively. 


# TDL editor plugin

To create a new TDL model by means of the TDLan2 textual representation, follow these steps:

- right click on a project or a folder in the package explorer and select New -> File,
- type the filename ending with **.tdlan2**
- the corresponding editor shall be automatically opened.

# TDL-TO editor plugin

To create a new TDL model by means of the TPlan2 textual representation for structured test objectives, follow this steps:

- right click on a project or a folder in the package explorer and select New -> File, 
- type the filename ending with **.tplan2** ,
- the corresponding editor shall be automatically opened.

# Convert the text into XF Format

- To translate a TDL model from the TDLan2 textual representation to the XF format (or the other way around), open the source model and press the "T" icon on the toolbar. The resulting model shall be stored in the same folder as the source model with the type of the model (**.tdlan2** or **.tdl**) appended to the name of the source model.

# Export TDL Structured Test Objectives and Test Purpose Descriptions as Word tables

## Install the plugin

Make sure that the TDL Word export plugin is installed. Find here [how to install the plugins](Installation). After the plugin is installed, you will be asked to restart the Eclipse environment.

After Eclipse restarts, you should be able to see a `W` button in the toolbar below the main menu.

![Toolbar.PNG](images/Toolbar.PNG)

## Use the export button!

1. Open a **tplan2** or a **tdltx/tdltxi** document containing structured test objectives and/or test purpose descriptions in Eclipse like this

[![Tdlan example.PNG](https://tdl.etsi.org/wiki/images/8/8a/Tdlan_example.PNG)](https://tdl.etsi.org/wiki/index.php/File:Tdlan_example.PNG)

2. Click on the `W` button in the toolbar and select the preferred template. It may happen that the Eclipse window is not responsive to clicks during the export execution, it does not mean that it is an error.
3. When the processing is done, the newly created Word document will be in the same folder of the tplan/tdltx/tdltxi file and should appear in the Project Explorer
4. If the file is not shown, select the project, right click and select *Refresh* (or hit F5 on the keyboard)

The result will look like:

[![Word.PNG](https://tdl.etsi.org/wiki/images/8/8b/Word.PNG)](https://tdl.etsi.org/wiki/index.php/File:Word.PNG)

The result includes relevant parts of the original structured test objective / test purpose description substituted the corresponding placeholders in the templates. Some keywords may be substituted as part of the process (e.g. "entity" keywords, etc.). Textual comments are also included. To exclude certain textual comments from the output, add a "!" prefix in the comment, e.g.:

```
//Comment to be included
//! Comment to be excluded
```
The output will include only the first comment.


# Translate TDL to TTCN-3

To tranlate a TDL model to TTCN-3 make sure to previously install the [TRex2/T3 Tools](https://t3tools.informatik.uni-goettingen.de/trac) and the components from the update site:

https://t3tools.informatik.uni-goettingen.de/downloads/trex2/

The translation from a TDL model to TTCN-3 code is done by selecting the TDL model and then press the **T3** icon in the TDL toolbar. The result of the translation is a 
a TTCN-3 file with the same name as the TDL model file with the extension .ttcn3 placed in the same folder as the TDL model.

# Test execution and result analysis

[[Test execution]]

