The TOP project has been created to grow a community around TDL the test description language. The language is specified by ETSI Methods for Testing and Specification committe (TC MTS) as an independent, extensible testing language.

You can find more information about ETSI (European Telecommunication Standards Institute) at [www.etsi.org](http://www.etsi.org/) and the information and work program of TC MTS [here](https://portal.etsi.org/tb.aspx?tbid=97&SubTB=97).

The governing rules are decided within TC MTS itself.

## TOP Governing groups

### Project lead (PL)

This is a small group of people from from TC MTS and ETSI CTI that deals with:

* Providing project timeline and roadmap,
* Ensuring IP compliance of code base,
* Deciding on TOP roles assignement.

### Steering Group (SG)

TOP Steering Group is formed by the people in the TDL Steering Group. Its tasks:

* To coordinate TOP's technical activities
* To provide guidelines for future development
* To resolve conflicts at technical level
* To guarantee neutrality from contributors

### Advisory group (AG)

The Advisory Group for TOP is ETSI TC MTS itself. Decisions regarding TOP are taken at MTS meetings, held usually every 3 months. The advisory groups goals are:
* To set the policies of the project
* To make administrative decisions
* To coordinate marketing efforts

Find out [how to participate in TC MTS](mailto:membership@etsi.org).

## Roles

### User

* Browse and download code base.
* Join the mailing list or forum, access to wiki

### Contributor

Same as user plus:
* Create a new issue / bug report
* Provide bug fixes as code patches
* Create new feature requests
* Provide code and tests for new features
* Contribute to the TOP wiki

Anybody is welcome to contribute code and ideas to the TOP project.

Find out [how to contribute](How-to-contribute).

### Committer 

Same as contributor plus:
* Consolidate code changes
* Ensure software quality and validate bug fixes
* Manage new versions and branches

## Access Rights

The following rules are used to assign access rights to the TOP Group and Projects on the ETSI Labs Gitlab server, for both members of Testing Task Forces assigned to develop the project, and to volunteers who have signed the Contributors License Agreement:

- TTF Leader and MTS Chair get Maintainer level rights to the whole TDL Open Source group, for as long as they are in these roles. 
- Individuals or representatives of an organisation which has signed a Contributor License Agreement get Developer level access to the TOP IDE group.
- Members of a current TTF get Developer access at TDL Open Source group level. They also get assigned Developer access to their specific TTF project. This level of access can be upgraded to Maintainer (for the TTF or for the group) if required - TTF leader to decide. 
- Members of a closed TTF retain their Developer access to that TTF project but lose it for all other groups, unless they've signed the CLA or are on another active TTF. 
