/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.UndeclaredStatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.source.ImplicitSubstatement;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ForwardingUndeclaredCurrent;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.InferredStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.OriginalStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReactorStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;

class UndeclaredStmtCtx<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends OriginalStmtCtx<A, D, E>
implements EffectiveStmtCtx.UndeclaredCurrent<A, D> {
    private final StatementContextBase<?, ?, ?> parent;
    private final A argument;

    private UndeclaredStmtCtx(UndeclaredStmtCtx<A, D, E> original, StatementContextBase<?, ?, ?> parent) {
        super(original);
        this.parent = Objects.requireNonNull(parent);
        this.argument = original.argument;
    }

    UndeclaredStmtCtx(StatementContextBase<?, ?, ?> parent, StatementSupport<A, D, E> support, @Nullable A argument) {
        super(new StatementDefinitionContext<A, D, E>(support), (StatementSourceReference)ImplicitSubstatement.of((StatementSourceReference)parent.sourceReference()));
        this.parent = Objects.requireNonNull(parent);
        this.argument = argument != null ? argument : this.definition().parseArgumentValue(this, (String)null);
    }

    UndeclaredStmtCtx(StatementContextBase<?, ?, ?> original, StatementSupport<A, D, E> support) {
        super(new StatementDefinitionContext<A, D, E>(UndeclaredStmtCtx.verifySupport(support)), original.sourceReference(), original.getLastOperation());
        this.parent = original.getParentContext();
        this.argument = UndeclaredStmtCtx.castArgument(original);
    }

    UndeclaredStmtCtx(StatementContextBase<?, ?, ?> parent, StatementSupport<A, D, E> support, StatementContextBase<?, ?, ?> original, CopyType type) {
        super(new StatementDefinitionContext<A, D, E>(UndeclaredStmtCtx.verifySupport(support)), original.sourceReference(), type);
        this.parent = Objects.requireNonNull(parent);
        this.argument = UndeclaredStmtCtx.castArgument(original);
    }

    UndeclaredStmtCtx(StatementContextBase<?, ?, ?> parent, StatementSupport<A, D, E> support, String rawArgument) {
        super(new StatementDefinitionContext<A, D, E>(support), (StatementSourceReference)ImplicitSubstatement.of((StatementSourceReference)parent.sourceReference()));
        this.parent = Objects.requireNonNull(parent);
        this.argument = this.definition().parseArgumentValue(this, rawArgument);
    }

    private static <A> @NonNull A castArgument(StatementContextBase<?, ?, ?> original) {
        return (A)original.getArgument();
    }

    private static <T> T verifySupport(T support) {
        Verify.verify((boolean)(support instanceof UndeclaredStatementFactory), (String)"Unexpected statement support %s", support);
        return support;
    }

    @Override
    public Collection<? extends StatementContextBase<?, ?, ?>> mutableDeclaredSubstatements() {
        return ImmutableList.of();
    }

    @Override
    Stream<? extends @NonNull ReactorStmtCtx<?, ?, ?>> streamDeclared() {
        return Stream.empty();
    }

    @Override
    void dropDeclaredSubstatements() {
    }

    @Override
    UndeclaredStmtCtx<A, D, E> reparent(StatementContextBase<?, ?, ?> newParent) {
        return new UndeclaredStmtCtx<A, D, E>(this, newParent);
    }

    @Override
    E createEffective(StatementFactory<A, D, E> factory) {
        return UndeclaredStmtCtx.createEffective(factory, this, this.streamEffective());
    }

    private static <A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> @NonNull E createEffective(@NonNull StatementFactory<A, D, E> factory, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EffectiveStmtCtx.UndeclaredCurrent<A, D> ctx, @NonNull Stream<? extends StmtContext<?, ?, ?>> substatements) {
        Verify.verify((boolean)(factory instanceof UndeclaredStatementFactory), (String)"Unexpected factory %s", factory);
        return (E)((UndeclaredStatementFactory)factory).createUndeclaredEffective(ctx, substatements);
    }

    @Override
    E createInferredEffective(StatementFactory<A, D, E> factory, InferredStatementContext<A, D, E> ctx, Stream<? extends ReactorStmtCtx<?, ?, ?>> declared, Stream<? extends ReactorStmtCtx<?, ?, ?>> effective) {
        long declaredCount = declared.count();
        Verify.verify((declaredCount == 0L ? 1 : 0) != 0, (String)"Unexpected non-empty declared statements in %s", ctx);
        return UndeclaredStmtCtx.createEffective(factory, new ForwardingUndeclaredCurrent(ctx), effective);
    }

    public A argument() {
        return this.argument;
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentContext() {
        return this.parent;
    }

    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.STATEMENT_LOCAL;
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentNamespaceStorage() {
        return this.parent;
    }

    @Override
    public RootStatementContext<?, ?, ?> getRoot() {
        return this.parent.getRoot();
    }

    public EffectiveStmtCtx.Parent.EffectiveConfig effectiveConfig() {
        return this.effectiveConfig(this.parent);
    }

    @Override
    protected boolean isIgnoringIfFeatures() {
        return this.isIgnoringIfFeatures(this.parent);
    }

    @Override
    protected boolean isIgnoringConfig() {
        return this.isIgnoringConfig(this.parent);
    }

    @Override
    protected boolean isParentSupportedByFeatures() {
        return this.parent.isSupportedByFeatures();
    }
}

