/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.primitives.UnsignedLong;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.util.DurationWithTime;

class ConcurrentDurationStatisticsTracker
extends DurationStatisticsTracker {
    private static final VarHandle SUM;
    private static final VarHandle COUNT;
    private static final VarHandle LONGEST;
    private static final VarHandle SHORTEST;
    private volatile long sum;
    private volatile long count;
    @SuppressFBWarnings(value={"UWF_NULL_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile DurationWithTime longest;
    @SuppressFBWarnings(value={"UWF_NULL_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile DurationWithTime shortest;

    ConcurrentDurationStatisticsTracker() {
    }

    @Override
    public final void addDuration(long duration) {
        DurationWithTime currentLongest;
        SUM.getAndAdd(this, duration);
        COUNT.getAndAdd(this, 1L);
        DurationWithTime currentShortest = SHORTEST.getAcquire(this);
        if (currentShortest == null || duration < currentShortest.duration()) {
            this.updateShortest(currentShortest, duration);
        }
        if ((currentLongest = LONGEST.getAcquire(this)) == null || duration > currentLongest.duration()) {
            this.updateLongest(currentLongest, duration);
        }
    }

    private void updateShortest(DurationWithTime prev, long duration) {
        DurationWithTime witness;
        DurationWithTime newObj = new DurationWithTime(duration, System.currentTimeMillis());
        DurationWithTime expected = prev;
        while ((witness = SHORTEST.compareAndExchangeRelease(this, expected, newObj)) != expected && duration < witness.duration()) {
            expected = witness;
        }
    }

    private void updateLongest(DurationWithTime prev, long duration) {
        DurationWithTime witness;
        DurationWithTime newObj = new DurationWithTime(duration, System.currentTimeMillis());
        DurationWithTime expected = prev;
        while ((witness = LONGEST.compareAndExchangeRelease(this, expected, newObj)) != expected && duration > witness.duration()) {
            expected = witness;
        }
    }

    @Override
    public final long getTotalDurations() {
        return this.count;
    }

    @Override
    public final double getAverageDuration() {
        long myCount = this.count;
        return myCount == 0L ? 0.0 : UnsignedLong.fromLongBits((long)this.sum).doubleValue() / (double)myCount;
    }

    @Override
    public final synchronized void reset() {
        this.longest = null;
        this.shortest = null;
        this.count = 0L;
        this.sum = 0L;
    }

    @Override
    protected final DurationWithTime getLongest() {
        return this.longest;
    }

    @Override
    protected final DurationWithTime getShortest() {
        return this.shortest;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            SUM = lookup.findVarHandle(ConcurrentDurationStatisticsTracker.class, "sum", Long.TYPE);
            COUNT = lookup.findVarHandle(ConcurrentDurationStatisticsTracker.class, "count", Long.TYPE);
            LONGEST = lookup.findVarHandle(ConcurrentDurationStatisticsTracker.class, "longest", DurationWithTime.class);
            SHORTEST = lookup.findVarHandle(ConcurrentDurationStatisticsTracker.class, "shortest", DurationWithTime.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

