/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta.AbstractImplicitStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

abstract class AbstractOperationContainerStatementSupport<D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>>
extends AbstractImplicitStatementSupport<D, E> {
    private final Function<QNameModule, QName> createArgument;

    AbstractOperationContainerStatementSupport(StatementDefinition publicDefinition, YangParserConfiguration config, SubstatementValidator validator, Function<QNameModule, QName> createArgument) {
        super(publicDefinition, AbstractOperationContainerStatementSupport.uninstantiatedPolicy(), config, validator);
        this.createArgument = Objects.requireNonNull(createArgument);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return this.createArgument.apply(StmtContextUtils.getRootModuleQName(ctx));
    }

    protected final E createEffective(EffectiveStmtCtx.Current<QName, D> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        try {
            return this.createEffective(EffectiveStmtUtils.historyAndStatusFlags((CopyableNode)stmt.history(), substatements), stmt, substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    abstract @NonNull E createEffective(int var1, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EffectiveStmtCtx.Current<QName, D> var2, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var3);

    public final @NonNull E copyEffective(EffectiveStmtCtx.Current<QName, D> stmt, E original) {
        return this.copyEffective(EffectiveStmtUtils.historyAndStatusFlags((CopyableNode)stmt.history(), original.effectiveSubstatements()), stmt, original);
    }

    abstract @NonNull E copyEffective(int var1, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EffectiveStmtCtx.Current<QName, D> var2, @NonNull E var3);

    @Override
    final E createUndeclaredEffective(EffectiveStmtCtx.UndeclaredCurrent<QName, D> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return this.createUndeclaredEffective(EffectiveStmtUtils.historyAndStatusFlags((CopyableNode)stmt.history(), substatements), stmt, substatements);
    }

    abstract @NonNull E createUndeclaredEffective(int var1, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EffectiveStmtCtx.UndeclaredCurrent<QName, D> var2, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var3);

    public final EffectiveStatementState extractEffectiveState(E stmt) {
        Verify.verify((boolean)(stmt instanceof ContainerLike), (String)"Unexpected statement %s", stmt);
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), EffectiveStmtUtils.historyAndStatusFlags((ContainerLike)stmt));
    }
}

