/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.opendaylight.yangtools.yang.parser.spi.source.ExplicitStatement;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class StatementSourceReferenceHandler
extends DefaultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StatementSourceReferenceHandler.class);
    private static final String USER_DATA_KEY = StatementSourceReference.class.getName();
    private final Deque<Element> stack = new ArrayDeque<Element>();
    private final StringBuilder sb = new StringBuilder();
    private final Document doc;
    private final String file;
    private Locator documentLocator;

    StatementSourceReferenceHandler(Document doc, String file) {
        this.doc = Objects.requireNonNull(doc);
        this.file = file;
    }

    static StatementSourceReference extractRef(Element element) {
        Object value = element.getUserData(USER_DATA_KEY);
        if (value instanceof StatementSourceReference) {
            return (StatementSourceReference)value;
        }
        if (value != null) {
            LOG.debug("Ignoring {} attached to key {}", value, (Object)USER_DATA_KEY);
        }
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.documentLocator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.addTextIfNeeded();
        Element el = this.doc.createElementNS(uri, qName);
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            el.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
        }
        ExplicitStatement ref = ExplicitStatement.atPosition((String)this.file, (int)this.documentLocator.getLineNumber(), (int)this.documentLocator.getColumnNumber());
        el.setUserData(USER_DATA_KEY, ref, null);
        this.stack.push(el);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.addTextIfNeeded();
        Element closedEl = this.stack.pop();
        Node parentEl = this.stack.peek();
        if (parentEl == null) {
            parentEl = this.doc;
        }
        parentEl.appendChild(closedEl);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.sb.append(ch, start, length);
    }

    private void addTextIfNeeded() {
        if (this.sb.length() > 0) {
            this.stack.peek().appendChild(this.doc.createTextNode(this.sb.toString()));
            this.sb.setLength(0);
        }
    }
}

