/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.ImmutableOffsetMapTemplate;
import org.opendaylight.yangtools.util.SharedSingletonMapTemplate;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ImmutableMapTemplate<K>
implements Immutable {
    ImmutableMapTemplate() {
    }

    public static <K> @NonNull ImmutableMapTemplate<K> ordered(Collection<K> keys) {
        return switch (keys.size()) {
            case 0 -> throw new IllegalArgumentException("Proposed keyset must not be empty");
            case 1 -> SharedSingletonMapTemplate.ordered(keys.iterator().next());
            default -> ImmutableOffsetMapTemplate.ordered(keys);
        };
    }

    public static <K> @NonNull ImmutableMapTemplate<K> unordered(Collection<K> keys) {
        return switch (keys.size()) {
            case 0 -> throw new IllegalArgumentException("Proposed keyset must not be empty");
            case 1 -> SharedSingletonMapTemplate.unordered(keys.iterator().next());
            default -> ImmutableOffsetMapTemplate.unordered(keys);
        };
    }

    public abstract <T, V> @NonNull UnmodifiableMapPhase<K, V> instantiateTransformed(Map<K, T> var1, BiFunction<K, T, V> var2);

    public abstract <V> @NonNull UnmodifiableMapPhase<K, V> instantiateWithValues(V ... var1);

    public abstract Set<K> keySet();

    final <T, V> @NonNull V transformValue(K key, T input, BiFunction<K, T, V> transformer) {
        V value = transformer.apply(key, input);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Transformer returned null for input %s at key %s", input, key);
        return value;
    }
}

