/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.AbstractResumedStatement;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SourceSpecificContext;

final class StatementContextWriter
implements StatementWriter {
    private final @NonNull ModelProcessingPhase phase;
    private final SourceSpecificContext ctx;
    private AbstractResumedStatement<?, ?, ?> current;

    StatementContextWriter(SourceSpecificContext ctx, ModelProcessingPhase phase) {
        this.ctx = Objects.requireNonNull(ctx);
        this.phase = Objects.requireNonNull(phase);
    }

    public ModelProcessingPhase getPhase() {
        return this.phase;
    }

    public Optional<? extends StatementWriter.ResumedStatement> resumeStatement(int childId) {
        AbstractResumedStatement<?, ?, ?> existing = StatementContextWriter.lookupDeclaredChild(this.current, childId);
        if (existing != null) {
            this.resumeStatement(existing);
            return Optional.of(existing);
        }
        return Optional.empty();
    }

    private void resumeStatement(AbstractResumedStatement<?, ?, ?> child) {
        if (child.isFullyDefined()) {
            child.declarationFinished(this.phase);
        } else {
            this.current = child;
        }
    }

    public void storeStatement(int expectedChildren, boolean fullyDefined) {
        Preconditions.checkState((this.current != null ? 1 : 0) != 0);
        Preconditions.checkArgument((expectedChildren >= 0 ? 1 : 0) != 0);
        this.current.resizeSubstatements(expectedChildren);
        if (fullyDefined) {
            this.current.setFullyDefined();
        }
    }

    public void startStatement(int childId, QName name, String argument, StatementSourceReference ref) {
        AbstractResumedStatement existing = StatementContextWriter.lookupDeclaredChild(this.current, childId);
        this.current = existing != null ? existing : (AbstractResumedStatement)Verify.verifyNotNull(this.ctx.createDeclaredChild(this.current, childId, name, argument, ref));
    }

    public void endStatement(StatementSourceReference ref) {
        Preconditions.checkState((this.current != null ? 1 : 0) != 0);
        this.current = this.current.exitStatement(this.phase);
    }

    private static @Nullable AbstractResumedStatement<?, ?, ?> lookupDeclaredChild(AbstractResumedStatement<?, ?, ?> current, int childId) {
        return current == null ? null : current.enterSubstatement(childId);
    }
}

