/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.JavaLengthConstraints;
import org.opendaylight.yangtools.yang.model.ri.type.LengthRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.RestrictedStringType;

public final class StringTypeBuilder
extends LengthRestrictedTypeBuilder<StringTypeDefinition> {
    private final List<PatternConstraint> patternConstraints = new ArrayList<PatternConstraint>(0);

    StringTypeBuilder(StringTypeDefinition baseType, QName qname) {
        super(baseType, qname);
    }

    public StringTypeBuilder addPatternConstraint(PatternConstraint constraint) {
        this.patternConstraints.add(Objects.requireNonNull(constraint));
        this.touch();
        return this;
    }

    @Override
    LengthConstraint typeLengthConstraints() {
        return JavaLengthConstraints.INTEGER_SIZE_CONSTRAINTS;
    }

    @Override
    StringTypeDefinition buildType(@Nullable LengthConstraint constraint) {
        return new RestrictedStringType((StringTypeDefinition)this.getBaseType(), this.getQName(), this.getUnknownSchemaNodes(), constraint, this.patternConstraints);
    }
}

