/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.spi;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;

final class RefcountedRegistration {
    private final SchemaSourceRegistration<?> reg;
    private int refcount = 1;

    RefcountedRegistration(SchemaSourceRegistration<?> reg) {
        this.reg = Objects.requireNonNull(reg);
    }

    public void incRef() {
        ++this.refcount;
    }

    public boolean decRef() {
        Preconditions.checkState((this.refcount > 0 ? 1 : 0) != 0, (String)"Refcount underflow: %s", (int)this.refcount);
        if (0 == --this.refcount) {
            this.reg.close();
            return true;
        }
        return false;
    }
}

