/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AbstractUnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ImmutableUnkeyedListNode
extends AbstractUnkeyedListNode {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier name;

    private ImmutableUnkeyedListNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.name = Objects.requireNonNull(name);
    }

    static final @NonNull ImmutableUnkeyedListNode of(YangInstanceIdentifier.NodeIdentifier name, List<UnkeyedListEntryNode> value) {
        return value.isEmpty() ? new Empty(name) : new Regular(name, (ImmutableList<UnkeyedListEntryNode>)ImmutableList.copyOf(value));
    }

    public final YangInstanceIdentifier.NodeIdentifier name() {
        return this.name;
    }

    protected final ImmutableList<UnkeyedListEntryNode> wrappedValue() {
        return this.value();
    }

    protected abstract ImmutableList<UnkeyedListEntryNode> value();

    static final class Empty
    extends ImmutableUnkeyedListNode {
        Empty(YangInstanceIdentifier.NodeIdentifier name) {
            super(name);
        }

        @Override
        public ImmutableList<UnkeyedListEntryNode> value() {
            return ImmutableList.of();
        }

        public UnkeyedListEntryNode childAt(int position) {
            throw new IndexOutOfBoundsException();
        }

        public int size() {
            return 0;
        }

        protected int valueHashCode() {
            return 1;
        }

        protected boolean valueEquals(UnkeyedListNode other) {
            return other.isEmpty();
        }
    }

    private static final class Regular
    extends ImmutableUnkeyedListNode {
        private final @NonNull ImmutableList<UnkeyedListEntryNode> children;

        Regular(YangInstanceIdentifier.NodeIdentifier name, ImmutableList<UnkeyedListEntryNode> children) {
            super(name);
            this.children = Objects.requireNonNull(children);
        }

        public UnkeyedListEntryNode childAt(int position) {
            return (UnkeyedListEntryNode)this.children.get(position);
        }

        public int size() {
            return this.children.size();
        }

        protected int valueHashCode() {
            return this.children.hashCode();
        }

        @Override
        protected ImmutableList<UnkeyedListEntryNode> value() {
            return this.children;
        }

        protected boolean valueEquals(UnkeyedListNode other) {
            ImmutableList<UnkeyedListEntryNode> otherChildren;
            if (other instanceof Regular) {
                Regular immutableOther = (Regular)other;
                otherChildren = immutableOther.children;
            } else {
                otherChildren = other.body();
            }
            return otherChildren instanceof List ? this.children.equals(otherChildren) : Iterables.elementsEqual(this.children, otherChildren);
        }
    }
}

