/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.ir;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.ir.AbstractIRObject;
import org.opendaylight.yangtools.yang.ir.IRArgument;
import org.opendaylight.yangtools.yang.ir.IRKeyword;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
public abstract class IRStatement
extends AbstractIRObject {
    private final @NonNull IRKeyword keyword;
    private final IRArgument argument;

    IRStatement(IRKeyword keyword, IRArgument argument) {
        this.keyword = Objects.requireNonNull(keyword);
        this.argument = argument;
    }

    public static @NonNull IRStatement of(IRKeyword keyword, IRArgument argument, int line, int column, ImmutableList<IRStatement> statements) {
        return switch (statements.size()) {
            case 0 -> {
                if (line >= 0 && column >= 0) {
                    if (line <= 65535 && column <= 65535) {
                        yield new Z22(keyword, argument, line, column);
                    }
                    if (line <= 0xFFFFFF && column <= 255) {
                        yield new Z31(keyword, argument, line, column);
                    }
                }
                yield new Z44(keyword, argument, line, column);
            }
            case 1 -> new O44(keyword, argument, (IRStatement)statements.get(0), line, column);
            default -> new L44(keyword, argument, statements, line, column);
        };
    }

    public final @NonNull IRKeyword keyword() {
        return this.keyword;
    }

    public final @Nullable IRArgument argument() {
        return this.argument;
    }

    public @NonNull List<? extends IRStatement> statements() {
        return ImmutableList.of();
    }

    public abstract int startLine();

    public abstract int startColumn();

    @Override
    final StringBuilder toYangFragment(StringBuilder sb) {
        List<? extends IRStatement> statements;
        this.keyword.toYangFragment(sb);
        if (this.argument != null) {
            this.argument.toYangFragment(sb.append(' '));
        }
        if ((statements = this.statements()).isEmpty()) {
            return sb.append(';');
        }
        sb.append(" {\n");
        for (IRStatement iRStatement : statements) {
            iRStatement.toYangFragment(sb).append('\n');
        }
        return sb.append('}');
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.keyword, this.argument, this.statements()) ^ this.startLine() ^ this.startColumn();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof IRStatement)) return false;
        IRStatement other = (IRStatement)obj;
        if (!this.keyword.equals(other.keyword)) return false;
        if (!Objects.equals(this.argument, other.argument)) return false;
        if (this.startLine() != other.startLine()) return false;
        if (this.startColumn() != other.startColumn()) return false;
        if (!this.statements().equals(other.statements())) return false;
        return true;
    }

    static final class Z22
    extends IRStatement {
        private final short startLine;
        private final short startColumn;

        Z22(IRKeyword keyword, IRArgument argument, int startLine, int startColumn) {
            super(keyword, argument);
            this.startLine = (short)startLine;
            this.startColumn = (short)startColumn;
        }

        @Override
        public int startLine() {
            return Short.toUnsignedInt(this.startLine);
        }

        @Override
        public int startColumn() {
            return Short.toUnsignedInt(this.startColumn);
        }
    }

    static final class Z31
    extends IRStatement {
        private final int value;

        Z31(IRKeyword keyword, IRArgument argument, int startLine, int startColumn) {
            this(keyword, argument, startLine << 8 | startColumn & 0xFF);
        }

        Z31(IRKeyword keyword, IRArgument argument, int value) {
            super(keyword, argument);
            this.value = value;
        }

        @Override
        public int startLine() {
            return this.value >>> 8;
        }

        @Override
        public int startColumn() {
            return this.value & 0xFF;
        }

        int value() {
            return this.value;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static class Z44
    extends IRStatement {
        private final int startLine;
        private final int startColumn;

        Z44(IRKeyword keyword, IRArgument argument, int startLine, int startColumn) {
            super(keyword, argument);
            this.startLine = startLine;
            this.startColumn = startColumn;
        }

        @Override
        public final int startLine() {
            return this.startLine;
        }

        @Override
        public final int startColumn() {
            return this.startColumn;
        }
    }

    static final class O44
    extends Z44 {
        private final @NonNull IRStatement statement;

        O44(IRKeyword keyword, IRArgument argument, IRStatement statement, int startLine, int startColumn) {
            super(keyword, argument, startLine, startColumn);
            this.statement = Objects.requireNonNull(statement);
        }

        public ImmutableList<IRStatement> statements() {
            return ImmutableList.of((Object)this.statement);
        }
    }

    static final class L44
    extends Z44 {
        private final @NonNull ImmutableList<IRStatement> statements;

        L44(IRKeyword keyword, IRArgument argument, ImmutableList<IRStatement> statements, int startLine, int startColumn) {
            super(keyword, argument, startLine, startColumn);
            this.statements = Objects.requireNonNull(statements);
        }

        public ImmutableList<IRStatement> statements() {
            return this.statements;
        }
    }
}

