/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class StatusStatementSupport
extends AbstractStatementSupport<Status, StatusStatement, StatusEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.STATUS).build();

    public StatusStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.STATUS, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public Status parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return (Status)SourceException.throwIfNull((Object)Status.forArgument((String)value), ctx, (String)"Invalid status '%s', must be one of 'current', 'deprecated' or 'obsolete'", (Object[])new Object[]{value});
    }

    public String internArgument(String rawArgument) {
        return switch (rawArgument) {
            case "current" -> "current";
            case "deprecated" -> "deprecated";
            case "obsolete" -> "obsolete";
            default -> rawArgument;
        };
    }

    protected StatusStatement createDeclared(BoundStmtCtx<Status> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createStatus((Status)((Status)ctx.getArgument()), substatements);
    }

    protected StatusStatement attachDeclarationReference(StatusStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateStatus((StatusStatement)stmt, (DeclarationReference)reference);
    }

    protected StatusEffectiveStatement createEffective(EffectiveStmtCtx.Current<Status, StatusStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createStatus((StatusStatement)((StatusStatement)stmt.declared()), substatements);
    }
}

