/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;

@Beta
public interface CommonStmtCtx {
    public @NonNull StatementDefinition publicDefinition();

    default public <D extends DeclaredStatement<?>> boolean producesDeclared(Class<? super D> type) {
        return type.isAssignableFrom(this.publicDefinition().getDeclaredRepresentationClass());
    }

    default public <E extends EffectiveStatement<?, ?>> boolean producesEffective(Class<? super E> type) {
        return type.isAssignableFrom(this.publicDefinition().getEffectiveRepresentationClass());
    }

    public @NonNull StatementSourceReference sourceReference();

    public @Nullable String rawArgument();

    default public @NonNull String getRawArgument() {
        return (String)Verify.verifyNotNull((Object)this.rawArgument(), (String)"Statement context %s does not have an argument", (Object[])new Object[]{this});
    }
}

