/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.collect.ForwardingMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.opendaylight.yangtools.util.ReadWriteTrieMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.MutableTrieMap;

final class ReadOnlyTrieMap<K, V>
extends ForwardingMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyTrieMap.class);
    private static final VarHandle READ_ONLY;
    private final MutableTrieMap<K, V> readWrite;
    private final int size;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile ImmutableTrieMap<K, V> readOnly;

    ReadOnlyTrieMap(MutableTrieMap<K, V> map, int size) {
        this.readWrite = Objects.requireNonNull(map);
        this.size = size;
    }

    ReadWriteTrieMap<K, V> toReadWrite() {
        ReadWriteTrieMap ret = new ReadWriteTrieMap(this.readWrite.mutableSnapshot(), this.size);
        LOG.trace("Converted read-only TrieMap {} to read-write {}", (Object)this, ret);
        return ret;
    }

    protected ImmutableTrieMap<K, V> delegate() {
        ImmutableTrieMap<K, V> ret = READ_ONLY.getAcquire(this);
        return ret != null ? ret : this.loadReadOnly();
    }

    public int size() {
        return this.size;
    }

    private ImmutableTrieMap<K, V> loadReadOnly() {
        ImmutableTrieMap ret = this.readWrite.immutableSnapshot();
        Object witness = READ_ONLY.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (ImmutableTrieMap)witness;
    }

    static {
        try {
            READ_ONLY = MethodHandles.lookup().findVarHandle(ReadOnlyTrieMap.class, "readOnly", ImmutableTrieMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

