/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.transform.dom.DOMSource;
import org.checkerframework.checker.regex.qual.Regex;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.MountPointLabel;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterExclusiveRootContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterInvisibleContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterListContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterNamedObjectContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterObjectContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterRootContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterSharedRootContext;
import org.opendaylight.yangtools.yang.data.util.NormalizedNodeStreamWriterStack;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class JSONNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter,
NormalizedNodeStreamWriter.MountPointExtension {
    private static final boolean DEFAULT_EMIT_EMPTY_CONTAINERS = true;
    private static final @Regex String NUMBER_STRING = "-?\\d+(\\.\\d+)?";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    private static final @Regex String NOT_DECIMAL_NUMBER_STRING = "-?\\d+";
    private static final Pattern NOT_DECIMAL_NUMBER_PATTERN = Pattern.compile("-?\\d+");
    private final NormalizedNodeStreamWriterStack tracker;
    private final JSONCodecFactory codecs;
    private final JsonWriter writer;
    private JSONStreamWriterContext context;

    JSONNormalizedNodeStreamWriter(JSONCodecFactory codecFactory, NormalizedNodeStreamWriterStack tracker, JsonWriter writer, JSONStreamWriterRootContext rootContext) {
        this.writer = Objects.requireNonNull(writer);
        this.codecs = Objects.requireNonNull(codecFactory);
        this.tracker = Objects.requireNonNull(tracker);
        this.context = Objects.requireNonNull(rootContext);
    }

    public static NormalizedNodeStreamWriter createExclusiveWriter(JSONCodecFactory codecFactory, JsonWriter jsonWriter) {
        return JSONNormalizedNodeStreamWriter.createExclusiveWriter(codecFactory, jsonWriter, null);
    }

    public static NormalizedNodeStreamWriter createExclusiveWriter(JSONCodecFactory codecFactory, JsonWriter jsonWriter, @Nullable XMLNamespace initialNs) {
        return new Exclusive(codecFactory, NormalizedNodeStreamWriterStack.of((EffectiveModelContext)codecFactory.modelContext()), jsonWriter, new JSONStreamWriterExclusiveRootContext(initialNs));
    }

    public static NormalizedNodeStreamWriter createExclusiveWriter(JSONCodecFactory codecFactory, EffectiveStatementInference rootNode, XMLNamespace initialNs, JsonWriter jsonWriter) {
        return new Exclusive(codecFactory, NormalizedNodeStreamWriterStack.of((EffectiveStatementInference)rootNode), jsonWriter, new JSONStreamWriterExclusiveRootContext(initialNs));
    }

    public static NormalizedNodeStreamWriter createExclusiveWriter(JSONCodecFactory codecFactory, SchemaNodeIdentifier.Absolute path, XMLNamespace initialNs, JsonWriter jsonWriter) {
        return new Exclusive(codecFactory, NormalizedNodeStreamWriterStack.of((EffectiveModelContext)codecFactory.modelContext(), (SchemaNodeIdentifier.Absolute)path), jsonWriter, new JSONStreamWriterExclusiveRootContext(initialNs));
    }

    public static NormalizedNodeStreamWriter createNestedWriter(JSONCodecFactory codecFactory, JsonWriter jsonWriter) {
        return JSONNormalizedNodeStreamWriter.createNestedWriter(codecFactory, jsonWriter, null);
    }

    public static NormalizedNodeStreamWriter createNestedWriter(JSONCodecFactory codecFactory, JsonWriter jsonWriter, @Nullable XMLNamespace initialNs) {
        return new Nested(codecFactory, NormalizedNodeStreamWriterStack.of((EffectiveModelContext)codecFactory.modelContext()), jsonWriter, new JSONStreamWriterSharedRootContext(initialNs));
    }

    public static NormalizedNodeStreamWriter createNestedWriter(JSONCodecFactory codecFactory, SchemaNodeIdentifier.Absolute path, XMLNamespace initialNs, JsonWriter jsonWriter) {
        return new Nested(codecFactory, NormalizedNodeStreamWriterStack.of((EffectiveModelContext)codecFactory.modelContext(), (SchemaNodeIdentifier.Absolute)path), jsonWriter, new JSONStreamWriterSharedRootContext(initialNs));
    }

    public static NormalizedNodeStreamWriter createNestedWriter(JSONCodecFactory codecFactory, EffectiveStatementInference rootNode, XMLNamespace initialNs, JsonWriter jsonWriter) {
        return new Nested(codecFactory, NormalizedNodeStreamWriterStack.of((EffectiveStatementInference)rootNode), jsonWriter, new JSONStreamWriterSharedRootContext(initialNs));
    }

    public Collection<? extends NormalizedNodeStreamWriter.Extension> supportedExtensions() {
        return List.of(this);
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.tracker.startLeafNode(name);
        this.context.emittingChild(this.codecs.modelContext(), this.writer);
        this.context.writeChildJsonIdentifier(this.codecs.modelContext(), this.writer, name.getNodeType());
    }

    public final void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startLeafSet(name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        this.tracker.startLeafSetEntryNode(name);
        this.context.emittingChild(this.codecs.modelContext(), this.writer);
    }

    public final void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startLeafSet(name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public final void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        boolean bl;
        ContainerLike containerLike = this.tracker.startContainerNode(name);
        if (containerLike instanceof ContainerSchemaNode) {
            ContainerSchemaNode container = (ContainerSchemaNode)containerLike;
            bl = container.isPresenceContainer();
        } else {
            bl = true;
        }
        boolean isPresence = bl;
        this.context = new JSONStreamWriterNamedObjectContext(this.context, (YangInstanceIdentifier.PathArgument)name, isPresence);
    }

    public final void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public final void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startListItem((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterObjectContext(this.context, (YangInstanceIdentifier.PathArgument)name, true);
    }

    public final void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public final void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        this.tracker.startListItem((YangInstanceIdentifier.PathArgument)identifier);
        this.context = new JSONStreamWriterObjectContext(this.context, (YangInstanceIdentifier.PathArgument)identifier, true);
    }

    public final void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public final void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startChoiceNode(name);
        this.context = new JSONStreamWriterInvisibleContext(this.context);
    }

    public final boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (NormalizedAnydata.class.isAssignableFrom(objectModel)) {
            this.tracker.startAnydataNode(name);
            this.context.emittingChild(this.codecs.modelContext(), this.writer);
            this.context.writeChildJsonIdentifier(this.codecs.modelContext(), this.writer, name.getNodeType());
            return true;
        }
        return false;
    }

    public final NormalizedNodeStreamWriter startMountPoint(MountPointLabel label, MountPointContext mountCtx) throws IOException {
        EffectiveModelContext ctx = mountCtx.modelContext();
        return new Nested(this.codecs.rebaseTo(ctx), NormalizedNodeStreamWriterStack.of((EffectiveModelContext)ctx), this.writer, new JSONStreamWriterSharedRootContext(this.context.getNamespace()));
    }

    public final boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (DOMSource.class.isAssignableFrom(objectModel)) {
            this.tracker.startAnyxmlNode(name);
            this.context.emittingChild(this.codecs.modelContext(), this.writer);
            this.context.writeChildJsonIdentifier(this.codecs.modelContext(), this.writer, name.getNodeType());
            return true;
        }
        return false;
    }

    public final void endNode() throws IOException {
        this.tracker.endNode();
        this.context = this.context.endNode(this.codecs.modelContext(), this.writer);
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    final void closeWriter() throws IOException {
        if (!(this.context instanceof JSONStreamWriterRootContext)) {
            throw new IOException("Unexpected root context " + this.context);
        }
        this.context.endNode(this.codecs.modelContext(), this.writer);
        this.writer.close();
    }

    public void scalarValue(Object value) throws IOException {
        Object current = this.tracker.getParent();
        if (current instanceof TypedDataSchemaNode) {
            TypedDataSchemaNode typed = (TypedDataSchemaNode)current;
            this.writeValue(value, (JSONCodec)this.codecs.codecFor((TypeAware)typed, (LeafrefResolver)this.tracker));
        } else if (current instanceof AnydataSchemaNode) {
            this.writeAnydataValue(value);
        } else {
            throw new IllegalStateException(String.format("Cannot emit scalar %s for %s", value, current));
        }
    }

    public void domSourceValue(DOMSource value) throws IOException {
        Object current = this.tracker.getParent();
        Preconditions.checkState((boolean)(current instanceof AnyxmlSchemaNode), (String)"Cannot emit DOMSource %s for %s", (Object)value, (Object)current);
        this.writeAnyXmlValue(value);
    }

    private void writeValue(Object value, JSONCodec<?> codec) throws IOException {
        codec.writeValue(this.writer, value);
    }

    private void writeAnydataValue(Object value) throws IOException {
        if (!(value instanceof NormalizedAnydata)) {
            throw new IllegalStateException("Unexpected anydata value " + value);
        }
        NormalizedAnydata normalized = (NormalizedAnydata)value;
        this.writeNormalizedAnydata(normalized);
    }

    private void writeNormalizedAnydata(NormalizedAnydata anydata) throws IOException {
        SchemaInferenceStack.Inference inference;
        try {
            SchemaInferenceStack stack = SchemaInferenceStack.ofInference((EffectiveStatementInference)anydata.getInference());
            stack.exitToDataTree();
            inference = stack.toInference();
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException e) {
            throw new IOException("Cannot emit " + anydata, e);
        }
        anydata.writeTo(JSONNormalizedNodeStreamWriter.createNestedWriter(this.codecs.rebaseTo(inference.modelContext()), (EffectiveStatementInference)inference, this.context.getNamespace(), this.writer));
    }

    private void writeAnyXmlValue(DOMSource anyXmlValue) throws IOException {
        this.writeXmlNode(anyXmlValue.getNode());
    }

    private void writeXmlNode(Node node) throws IOException {
        if (JSONNormalizedNodeStreamWriter.isArrayElement(node)) {
            this.writeArrayContent(node);
            return;
        }
        Element firstChildElement = JSONNormalizedNodeStreamWriter.getFirstChildElement(node);
        if (firstChildElement == null) {
            this.writeXmlValue(node);
        } else {
            this.writeObjectContent(firstChildElement);
        }
    }

    private void writeArrayContent(Node node) throws IOException {
        this.writer.beginArray();
        this.handleArray(node);
        this.writer.endArray();
    }

    private void writeObjectContent(Element firstChildElement) throws IOException {
        this.writer.beginObject();
        this.writeObject(firstChildElement);
        this.writer.endObject();
    }

    private static boolean isArrayElement(Node node) {
        if (1 == node.getNodeType()) {
            String nodeName = node.getNodeName();
            for (Node nextNode = node.getNextSibling(); nextNode != null; nextNode = nextNode.getNextSibling()) {
                if (1 != nextNode.getNodeType() || !nodeName.equals(nextNode.getNodeName())) continue;
                return true;
            }
        }
        return false;
    }

    private void handleArray(Node node) throws IOException {
        Element parentNode = (Element)node.getParentNode();
        NodeList elementsList = parentNode.getElementsByTagName(node.getNodeName());
        int length = elementsList.getLength();
        for (int i = 0; i < length; ++i) {
            Node arrayElement = elementsList.item(i);
            Element parent = (Element)arrayElement.getParentNode();
            if (!parentNode.isSameNode(parent)) continue;
            Element firstChildElement = JSONNormalizedNodeStreamWriter.getFirstChildElement(arrayElement);
            if (firstChildElement != null) {
                this.writeObjectContent(firstChildElement);
                continue;
            }
            this.writeXmlValue(arrayElement);
        }
    }

    private void writeObject(Node node) throws IOException {
        HashSet<String> previousNodeNames = new HashSet<String>();
        while (node != null) {
            String nodeName;
            if (1 == node.getNodeType() && previousNodeNames.add(nodeName = node.getNodeName())) {
                this.writer.name(nodeName);
                this.writeXmlNode(node);
            }
            node = node.getNextSibling();
        }
    }

    private void writeXmlValue(Node node) throws IOException {
        Text firstChild = JSONNormalizedNodeStreamWriter.getFirstChildText(node);
        String childNodeText = firstChild != null ? firstChild.getWholeText() : "";
        String string = childNodeText = childNodeText != null ? childNodeText.trim() : "";
        if (NUMBER_PATTERN.matcher(childNodeText).matches()) {
            this.writer.value(JSONNormalizedNodeStreamWriter.parseNumber(childNodeText));
            return;
        }
        switch (childNodeText) {
            case "null": {
                this.writer.nullValue();
                break;
            }
            case "false": {
                this.writer.value(false);
                break;
            }
            case "true": {
                this.writer.value(true);
                break;
            }
            default: {
                this.writer.value(childNodeText);
            }
        }
    }

    private static Element getFirstChildElement(Node node) {
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = children.item(i);
            if (1 != childNode.getNodeType()) continue;
            return (Element)childNode;
        }
        return null;
    }

    private static Text getFirstChildText(Node node) {
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = children.item(i);
            if (3 != childNode.getNodeType()) continue;
            return (Text)childNode;
        }
        return null;
    }

    private static Number parseNumber(String numberText) {
        if (NOT_DECIMAL_NUMBER_PATTERN.matcher(numberText).matches()) {
            return Long.valueOf(numberText);
        }
        return Double.valueOf(numberText);
    }

    private static final class Exclusive
    extends JSONNormalizedNodeStreamWriter {
        Exclusive(JSONCodecFactory codecFactory, NormalizedNodeStreamWriterStack tracker, JsonWriter writer, JSONStreamWriterRootContext rootContext) {
            super(codecFactory, tracker, writer, rootContext);
        }

        public void close() throws IOException {
            this.flush();
            this.closeWriter();
        }
    }

    private static final class Nested
    extends JSONNormalizedNodeStreamWriter {
        Nested(JSONCodecFactory codecFactory, NormalizedNodeStreamWriterStack tracker, JsonWriter writer, JSONStreamWriterRootContext rootContext) {
            super(codecFactory, tracker, writer, rootContext);
        }

        public void close() throws IOException {
            this.flush();
        }
    }
}

