/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

public class DataNodeContainerValidator {
    private final DataNodeContainer schema;
    private final Set<QName> childNodes;

    public DataNodeContainerValidator(DataNodeContainer schema) {
        this.schema = Objects.requireNonNull(schema, "Schema was null");
        this.childNodes = DataNodeContainerValidator.getChildNodes(schema);
    }

    private boolean isKnownChild(YangInstanceIdentifier.PathArgument child) {
        return this.childNodes.contains(child.getNodeType());
    }

    public void validateChild(YangInstanceIdentifier.PathArgument child) {
        DataValidationException.checkLegalChild(this.isKnownChild(child), child, this.schema, this.childNodes);
    }

    public DataContainerChild validateChild(DataContainerChild child) {
        this.validateChild((YangInstanceIdentifier.PathArgument)child.name());
        return child;
    }

    private static Set<QName> getChildNodes(DataNodeContainer nodeContainer) {
        HashSet<QName> allChildNodes = new HashSet<QName>();
        for (DataSchemaNode childSchema : nodeContainer.getChildNodes()) {
            if (childSchema instanceof CaseSchemaNode) {
                CaseSchemaNode caseChildSchema = (CaseSchemaNode)childSchema;
                allChildNodes.addAll(DataNodeContainerValidator.getChildNodes((DataNodeContainer)caseChildSchema));
                continue;
            }
            if (childSchema instanceof AugmentationSchemaNode) continue;
            allChildNodes.add(childSchema.getQName());
        }
        return allChildNodes;
    }
}

