/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;

public enum YangBinaryOperator {
    EQUALS("="),
    NOT_EQUALS("!="),
    GT(">"),
    GTE(">="),
    LT("<"),
    LTE("<="),
    PLUS("+"),
    MINUS("-"),
    MUL("*"),
    DIV("div"),
    MOD("mod");

    private final String str;

    private YangBinaryOperator(String str) {
        this.str = Objects.requireNonNull(str);
    }

    public YangBinaryExpr exprWith(YangExpr leftExpr, YangExpr rightExpr) {
        return new Expr(leftExpr, rightExpr);
    }

    public String toString() {
        return this.str;
    }

    @SuppressFBWarnings(value={"SE_INNER_CLASS"}, justification="Outer class is a retained enumeration")
    final class Expr
    extends YangBinaryExpr {
        private static final long serialVersionUID = 1L;

        Expr(YangExpr leftExpr, YangExpr rightExpr) {
            super(leftExpr, rightExpr);
        }

        @Override
        public YangBinaryOperator getOperator() {
            return YangBinaryOperator.this;
        }
    }
}

