/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6643.parser;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc6643.model.api.IetfYangSmiv2ExtensionsMapping;
import org.opendaylight.yangtools.rfc6643.model.api.MaxAccess;
import org.opendaylight.yangtools.rfc6643.model.api.MaxAccessEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.MaxAccessStatement;
import org.opendaylight.yangtools.rfc6643.parser.MaxAccessEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc6643.parser.MaxAccessStatementImpl;
import org.opendaylight.yangtools.rfc6643.parser.RefMaxAccessStatement;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class MaxAccessStatementSupport
extends AbstractStatementSupport<MaxAccess, MaxAccessStatement, MaxAccessEffectiveStatement> {
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)IetfYangSmiv2ExtensionsMapping.MAX_ACCESS).build();

    public MaxAccessStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)IetfYangSmiv2ExtensionsMapping.MAX_ACCESS, StatementSupport.StatementPolicy.contextIndependent(), config, VALIDATOR);
    }

    public MaxAccess parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        MaxAccess val = MaxAccess.forStringLiteral((String)value);
        if (val == null) {
            throw new SourceException(ctx, "Invalid max-access value '%s'", new Object[]{value});
        }
        return val;
    }

    public String internArgument(String rawArgument) {
        MaxAccess val = MaxAccess.forStringLiteral((String)rawArgument);
        return val == null ? rawArgument : val.stringLiteral();
    }

    protected MaxAccessStatement createDeclared(BoundStmtCtx<MaxAccess> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return new MaxAccessStatementImpl((MaxAccess)ctx.getArgument(), substatements);
    }

    protected MaxAccessStatement attachDeclarationReference(MaxAccessStatement stmt, DeclarationReference reference) {
        return new RefMaxAccessStatement(stmt, reference);
    }

    protected MaxAccessEffectiveStatement createEffective(EffectiveStmtCtx.Current<MaxAccess, MaxAccessStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new MaxAccessEffectiveStatementImpl(stmt, substatements);
    }
}

