/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public interface DataNodeContainer {
    public @NonNull Collection<? extends @NonNull TypeDefinition<?>> getTypeDefinitions();

    public @NonNull Collection<? extends @NonNull DataSchemaNode> getChildNodes();

    public @NonNull Collection<? extends @NonNull GroupingDefinition> getGroupings();

    public @Nullable DataSchemaNode dataChildByName(QName var1);

    default public @NonNull DataSchemaNode getDataChildByName(QName name) {
        return (DataSchemaNode)Verify.verifyNotNull((Object)this.dataChildByName(name), (String)"No child matching %s found", (Object[])new Object[]{name});
    }

    default public Optional<DataSchemaNode> findDataChildByName(QName name) {
        return Optional.ofNullable(this.dataChildByName(name));
    }

    default public Optional<DataSchemaNode> findDataChildByName(QName first, QName ... others) {
        DataSchemaNode current = this.dataChildByName(first);
        for (QName qname : others) {
            if (!(current instanceof DataNodeContainer)) {
                return Optional.empty();
            }
            DataNodeContainer container = (DataNodeContainer)((Object)current);
            current = container.dataChildByName(qname);
        }
        return Optional.ofNullable(current);
    }

    public @NonNull Collection<? extends @NonNull UsesNode> getUses();

    default public Optional<DataSchemaNode> findDataTreeChild(QName name) {
        DataSchemaNode dataChild = this.dataChildByName(name);
        if (DataNodeContainer.isDataNode(dataChild)) {
            return Optional.of(dataChild);
        }
        for (DataSchemaNode dataSchemaNode : this.getChildNodes()) {
            if (!(dataSchemaNode instanceof ChoiceSchemaNode)) continue;
            ChoiceSchemaNode choice = (ChoiceSchemaNode)dataSchemaNode;
            for (CaseSchemaNode caseSchemaNode : choice.getCases()) {
                Optional<DataSchemaNode> caseChild = caseSchemaNode.findDataTreeChild(name);
                if (!caseChild.isPresent()) continue;
                return caseChild;
            }
        }
        return Optional.empty();
    }

    default public Optional<DataSchemaNode> findDataTreeChild(QName ... path) {
        return this.findDataTreeChild(Arrays.asList(path));
    }

    default public Optional<DataSchemaNode> findDataTreeChild(Iterable<QName> path) {
        Iterator<QName> it = path.iterator();
        DataNodeContainer parent = this;
        Optional<DataSchemaNode> optChild;
        while (!(optChild = parent.findDataTreeChild(Objects.requireNonNull(it.next()))).isEmpty() && it.hasNext()) {
            DataSchemaNode child = optChild.orElseThrow();
            if (!(child instanceof DataNodeContainer)) {
                throw new IllegalArgumentException("Path " + path + " extends beyond terminal child " + child);
            }
            DataNodeContainer container = (DataNodeContainer)((Object)child);
            parent = container;
        }
        return optChild;
    }

    private static boolean isDataNode(DataSchemaNode node) {
        return node instanceof ContainerSchemaNode || node instanceof LeafSchemaNode || node instanceof LeafListSchemaNode || node instanceof ListSchemaNode || node instanceof AnydataSchemaNode || node instanceof AnyxmlSchemaNode;
    }
}

