/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class KeyStatementSupport
extends AbstractStatementSupport<Set<QName>, KeyStatement, KeyEffectiveStatement> {
    private static final CharMatcher SEP = CharMatcher.anyOf((CharSequence)" \n\r\t").precomputed();
    private static final Splitter KEY_ARG_SPLITTER = Splitter.on((CharMatcher)SEP).omitEmptyStrings();
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.KEY).build();

    public KeyStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.KEY, StatementSupport.StatementPolicy.copyDeclared((copy, current, substatements) -> copy.getArgument() == current.getArgument()), config, SUBSTATEMENT_VALIDATOR);
    }

    public ImmutableSet<QName> parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int tokens = 0;
        for (String keyToken : KEY_ARG_SPLITTER.split((CharSequence)value)) {
            builder.add((Object)StmtContextUtils.parseNodeIdentifier(ctx, (String)keyToken));
            ++tokens;
        }
        ImmutableSet ret = builder.build();
        SourceException.throwIf((ret.size() != tokens ? 1 : 0) != 0, ctx, (String)"Key argument '%s' contains duplicates", (Object[])new Object[]{value});
        return ret;
    }

    public Set<QName> adaptArgumentValue(StmtContext<Set<QName>, KeyStatement, KeyEffectiveStatement> ctx, QNameModule targetModule) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        boolean replaced = false;
        for (QName qname : (Set)ctx.getArgument()) {
            if (!targetModule.equals((Object)qname.getModule())) {
                QName newQname = qname.bindTo(targetModule).intern();
                builder.add((Object)newQname);
                replaced = true;
                continue;
            }
            builder.add((Object)qname);
        }
        return replaced ? builder.build() : (Set)ctx.argument();
    }

    protected KeyStatement createDeclared(BoundStmtCtx<Set<QName>> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createKey((String)ctx.getRawArgument(), (Set)((Set)ctx.getArgument()), substatements);
    }

    protected KeyStatement attachDeclarationReference(KeyStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateKey((KeyStatement)stmt, (DeclarationReference)reference);
    }

    protected KeyEffectiveStatement createEffective(EffectiveStmtCtx.Current<Set<QName>, KeyStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createKey((KeyStatement)((KeyStatement)stmt.declared()), (Set)((Set)stmt.getArgument()), substatements);
    }
}

