/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.ImportedVersionNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.RevisionImport;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractUnqualifiedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.YangVersionLinkageException;

@Beta
public final class ImportStatementSupport
extends AbstractUnqualifiedStatementSupport<ImportStatement, ImportEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.IMPORT).addMandatory((StatementDefinition)YangStmtMapping.PREFIX).addOptional((StatementDefinition)YangStmtMapping.REVISION_DATE).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.IMPORT).addMandatory((StatementDefinition)YangStmtMapping.PREFIX).addOptional((StatementDefinition)YangStmtMapping.REVISION_DATE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();

    private ImportStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.IMPORT, StatementSupport.StatementPolicy.reject(), config, validator);
    }

    public static @NonNull ImportStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new ImportStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull ImportStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new ImportStatementSupport(config, RFC7950_VALIDATOR);
    }

    public void onPreLinkageDeclared(final StmtContext.Mutable<UnresolvedQName.Unqualified, ImportStatement, ImportEffectiveStatement> stmt) {
        final SourceIdentifier importId = RevisionImport.getImportedSourceIdentifier(stmt);
        stmt.addRequiredSource(importId);
        final UnresolvedQName.Unqualified moduleName = (UnresolvedQName.Unqualified)stmt.getArgument();
        ModelActionBuilder importAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_PRE_LINKAGE);
        final ModelActionBuilder.Prerequisite imported = importAction.requiresCtx(stmt, ParserNamespaces.PRELINKAGE_MODULE, (Object)moduleName, ModelProcessingPhase.SOURCE_PRE_LINKAGE);
        final ModelActionBuilder.Prerequisite rootPrereq = importAction.mutatesCtx((StmtContext.Mutable)stmt.getRoot(), ModelProcessingPhase.SOURCE_PRE_LINKAGE);
        importAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                YangVersion importedVersion;
                StmtContext importedModuleContext = (StmtContext)imported.resolve(ctx);
                Verify.verify((boolean)moduleName.equals(importedModuleContext.getArgument()));
                XMLNamespace importedModuleNamespace = (XMLNamespace)Verify.verifyNotNull((Object)((XMLNamespace)importedModuleContext.namespaceItem(ParserNamespaces.MODULE_NAME_TO_NAMESPACE, (Object)moduleName)));
                String impPrefix = (String)SourceException.throwIfNull((Object)((String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class)), (CommonStmtCtx)stmt, (String)"Missing prefix statement", (Object[])new Object[0]);
                StmtContext.Mutable root = (StmtContext.Mutable)rootPrereq.resolve(ctx);
                if (importId.revision() != null && root.yangVersion() == YangVersion.VERSION_1 && (importedVersion = importedModuleContext.yangVersion()) != YangVersion.VERSION_1) {
                    throw new YangVersionLinkageException((CommonStmtCtx)stmt, "Cannot import by revision version %s module %s", new Object[]{importedVersion, moduleName.getLocalName()});
                }
                stmt.addToNs(ParserNamespaces.IMP_PREFIX_TO_NAMESPACE, (Object)impPrefix, (Object)importedModuleNamespace);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(imported), (CommonStmtCtx)stmt, (String)"Imported module [%s] was not found.", (Object[])new Object[]{moduleName.getLocalName()});
            }
        });
    }

    public void onLinkageDeclared(StmtContext.Mutable<UnresolvedQName.Unqualified, ImportStatement, ImportEffectiveStatement> stmt) {
        RevisionImport.onLinkageDeclared(stmt);
    }

    protected ImportStatement createDeclared(BoundStmtCtx<UnresolvedQName.Unqualified> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createImport((UnresolvedQName.Unqualified)((UnresolvedQName.Unqualified)ctx.getArgument()), substatements);
    }

    protected ImportStatement attachDeclarationReference(ImportStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateImport((ImportStatement)stmt, (DeclarationReference)reference);
    }

    protected ImportEffectiveStatement createEffective(EffectiveStmtCtx.Current<UnresolvedQName.Unqualified, ImportStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        InferenceException.throwIf((boolean)substatements.isEmpty(), stmt, (String)"Unexpected empty effective import statement", (Object[])new Object[0]);
        return EffectiveStatements.createImport((ImportStatement)((ImportStatement)stmt.declared()), substatements, (SourceIdentifier)((SourceIdentifier)Verify.verifyNotNull((Object)((SourceIdentifier)stmt.namespaceItem(ImportedVersionNamespace.INSTANCE, (Object)Empty.value())))));
    }
}

