/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.checkerframework.checker.index.qual.NonNegative;
import org.eclipse.jdt.annotation.NonNull;

public record SemVer(@NonNegative int major, @NonNegative int minor, @NonNegative int patch) implements Comparable<SemVer>,
Serializable
{
    private static final long serialVersionUID = 1L;

    public SemVer(@NonNegative int major, @NonNegative int minor, @NonNegative int patch) {
        Preconditions.checkArgument((major >= 0 ? 1 : 0) != 0, (Object)"Major version has to be non-negative");
        Preconditions.checkArgument((minor >= 0 ? 1 : 0) != 0, (Object)"Minor version has to be non-negative");
        Preconditions.checkArgument((patch >= 0 ? 1 : 0) != 0, (Object)"Patch version has to be non-negative");
    }

    public SemVer(@NonNegative int major) {
        this(major, 0);
    }

    public SemVer(@NonNegative int major, @NonNegative int minor) {
        this(major, minor, 0);
    }

    public static @NonNull SemVer valueOf(@NonNull String str) {
        int minorIdx = str.indexOf(46);
        if (minorIdx == -1) {
            return new SemVer(Integer.parseInt(str));
        }
        int patchIdx = str.indexOf(46, minorIdx + 1);
        if (patchIdx == -1) {
            String minorStr = str.substring(minorIdx + 1);
            return new SemVer(Integer.parseInt(str.substring(0, minorIdx), 10), Integer.parseInt(minorStr, 10));
        }
        String minorStr = str.substring(minorIdx + 1, patchIdx);
        return new SemVer(Integer.parseInt(str.substring(0, minorIdx), 10), Integer.parseInt(minorStr, 10), Integer.parseInt(str.substring(patchIdx + 1), 10));
    }

    @Override
    public int compareTo(SemVer other) {
        int cmp = Integer.compare(this.major, other.major);
        if (cmp == 0 && (cmp = Integer.compare(this.minor, other.minor)) == 0) {
            cmp = Integer.compare(this.patch, other.patch);
        }
        return cmp;
    }

    @Override
    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

