/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.ObjectExtension;

public interface ExtensibleObject<O extends ExtensibleObject<O, E>, E extends ObjectExtension<O, E>> {
    default public <T extends E> @Nullable T extension(Class<T> type) {
        Class<T> nonnull = Objects.requireNonNull(type);
        return (T)((ObjectExtension)this.supportedExtensions().stream().filter(nonnull::isInstance).findFirst().map(nonnull::cast).orElse(null));
    }

    default public <T extends E> Optional<T> findExtension(Class<T> type) {
        return Optional.ofNullable(this.extension(type));
    }

    default public @NonNull Collection<? extends E> supportedExtensions() {
        return List.of();
    }
}

