/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.spi;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.spi.AbstractSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;

@Beta
public final class SoftSchemaSourceCache<T extends SchemaSourceRepresentation>
extends AbstractSchemaSourceCache<T>
implements AutoCloseable {
    private static final Cleaner CLEANER = Cleaner.create();
    private final ConcurrentMap<SourceIdentifier, SoftReference<T>> references = new ConcurrentHashMap<SourceIdentifier, SoftReference<T>>();
    private final ConcurrentMap<Registration, Cleaner.Cleanable> cleanables = new ConcurrentHashMap<Registration, Cleaner.Cleanable>();
    private boolean closed;

    public SoftSchemaSourceCache(SchemaSourceRegistry consumer, Class<T> representation) {
        super(consumer, representation, PotentialSchemaSource.Costs.IMMEDIATE);
    }

    @Override
    public ListenableFuture<? extends T> getSource(SourceIdentifier sourceIdentifier) {
        SoftReference ref = (SoftReference)this.references.get(sourceIdentifier);
        if (ref != null) {
            SchemaSourceRepresentation src = (SchemaSourceRepresentation)ref.get();
            if (src != null) {
                return Futures.immediateFuture((Object)src);
            }
            this.references.remove(sourceIdentifier, ref);
        }
        return Futures.immediateFailedFuture((Throwable)new MissingSchemaSourceException("Source not found", sourceIdentifier));
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            while (!this.cleanables.isEmpty()) {
                this.cleanables.values().forEach(Cleaner.Cleanable::clean);
            }
        }
    }

    @Override
    protected synchronized void offer(T source) {
        SoftReference<T> prev;
        if (this.closed) {
            return;
        }
        SourceIdentifier id = source.getIdentifier();
        SoftReference<T> ref = new SoftReference<T>(source);
        while ((prev = this.references.putIfAbsent(id, ref)) != null) {
            if (prev.get() != null) {
                return;
            }
            this.references.remove(id, prev);
        }
        SchemaSourceRegistration reg = this.register(id);
        this.cleanables.put((Registration)reg, CLEANER.register(source, () -> {
            this.cleanables.remove(reg);
            reg.close();
            this.references.remove(id, ref);
        }));
        Reference.reachabilityFence(source);
    }
}

