/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.schema.MetadataNormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedMetadataWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NonNullByDefault
class ImmutableNormalizedAnydata
implements NormalizedAnydata {
    private final EffectiveStatementInference inference;
    private final NormalizedNode data;

    ImmutableNormalizedAnydata(EffectiveStatementInference inference, NormalizedNode data) {
        this.inference = Objects.requireNonNull(inference);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public EffectiveStatementInference getInference() {
        return this.inference;
    }

    @Override
    public NormalizedNode getData() {
        return this.data;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("inference", (Object)this.inference).add("data", (Object)this.data);
    }

    static final class WithMetadata
    extends ImmutableNormalizedAnydata
    implements MetadataNormalizedAnydata {
        private final NormalizedMetadata metadata;

        WithMetadata(EffectiveStatementInference inference, NormalizedNode data, NormalizedMetadata metadata) {
            super(inference, data);
            this.metadata = Objects.requireNonNull(metadata);
        }

        @Override
        public NormalizedMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public void writeTo(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves) throws IOException {
            NormalizedMetadataWriter.forStreamWriter(writer, orderKeyLeaves).write(this.getData(), this.getMetadata()).flush();
        }
    }
}

