/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.QName;

@NonNullByDefault
public record AnnotationName(QName qname) implements Identifier,
WritableObject
{
    private static final long serialVersionUID = 1L;
    private static final Interner<AnnotationName> INTERNER = Interners.newWeakInterner();

    public AnnotationName {
        Objects.requireNonNull(qname);
    }

    public AnnotationName intern() {
        QName cacheQName = this.qname.intern();
        AnnotationName template = cacheQName == this.qname ? this : new AnnotationName(cacheQName);
        return (AnnotationName)INTERNER.intern((Object)template);
    }

    public static AnnotationName readFrom(DataInput in) throws IOException {
        return new AnnotationName(QName.readFrom(in));
    }

    public void writeTo(DataOutput out) throws IOException {
        this.qname.writeTo(out);
    }
}

