/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.VerifyException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ImmutableMapTemplate;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.AbstractMountPointDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ListEntryNodeDataWithSchema
extends AbstractMountPointDataWithSchema<ListSchemaNode> {
    ListEntryNodeDataWithSchema(ListSchemaNode schema) {
        super(schema);
    }

    static @NonNull ListEntryNodeDataWithSchema forSchema(ListSchemaNode schema) {
        List keyDef = schema.getKeyDefinition();
        return keyDef.isEmpty() ? new Unkeyed(schema) : new Keyed(schema, keyDef);
    }

    private static final class Unkeyed
    extends ListEntryNodeDataWithSchema {
        Unkeyed(ListSchemaNode schema) {
            super(schema);
        }

        @Override
        public void write(NormalizedNodeStreamWriter writer, NormalizedNodeStreamWriter.MetadataExtension metaWriter) throws IOException {
            writer.nextDataSchemaNode(this.getSchema());
            writer.startUnkeyedListItem(this.provideNodeIdentifier(), this.childSizeHint());
            super.write(writer, metaWriter);
            writer.endNode();
        }
    }

    private static final class Keyed
    extends ListEntryNodeDataWithSchema {
        private final Map<QName, SimpleNodeDataWithSchema<?>> keyValues = new HashMap();
        private final ImmutableMapTemplate<QName> predicateTemplate;

        Keyed(ListSchemaNode schema, List<QName> keyDef) {
            super(schema);
            this.predicateTemplate = ImmutableMapTemplate.ordered(keyDef);
        }

        @Override
        void addChild(AbstractNodeDataWithSchema<?> newChild) {
            Object obj = newChild.getSchema();
            if (obj instanceof LeafSchemaNode) {
                LeafSchemaNode leaf = (LeafSchemaNode)obj;
                QName childName = leaf.getQName();
                if (this.predicateTemplate.keySet().contains(childName)) {
                    if (newChild instanceof SimpleNodeDataWithSchema) {
                        SimpleNodeDataWithSchema simpleChild = (SimpleNodeDataWithSchema)newChild;
                        this.keyValues.put(childName, simpleChild);
                    } else {
                        throw new VerifyException("Unexpected child " + newChild);
                    }
                }
            }
            super.addChild(newChild);
        }

        @Override
        public void write(NormalizedNodeStreamWriter writer, NormalizedNodeStreamWriter.MetadataExtension metaWriter) throws IOException {
            UnmodifiableMapPhase predicates;
            ListSchemaNode schema = (ListSchemaNode)this.getSchema();
            writer.nextDataSchemaNode((DataSchemaNode)schema);
            QName nodeType = schema.getQName();
            try {
                predicates = this.predicateTemplate.instantiateTransformed(this.keyValues, (key, node) -> node.getValue());
            }
            catch (IllegalArgumentException e) {
                Set<QName> present = this.keyValues.keySet();
                QNameModule module = nodeType.getModule();
                List<Serializable> missing = this.predicateTemplate.keySet().stream().filter(key -> !present.contains(key)).map(key -> module.equals((Object)key.getModule()) ? key.getLocalName() : key).distinct().toList();
                throw new IOException("List entry " + nodeType + " is missing leaf values for " + missing, e);
            }
            writer.startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)nodeType, (Map)predicates), this.childSizeHint());
            this.writeMetadata(metaWriter);
            super.write(writer, metaWriter);
            writer.endNode();
        }
    }
}

