/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.Verify;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.XMLNamespace;

final class XNv1
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private XMLNamespace namespace;

    public XNv1() {
    }

    XNv1(XMLNamespace namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.namespace.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        try {
            this.namespace = XMLNamespace.of(in.readUTF());
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid namespace", e);
        }
    }

    Object readResolve() {
        return Verify.verifyNotNull((Object)this.namespace);
    }
}

