/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.refine;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.refine.RefineEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.refine.RefineTargetNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public final class RefineStatementSupport
extends AbstractStatementSupport<SchemaNodeIdentifier.Descendant, RefineStatement, RefineEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.REFINE).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.PRESENCE).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.REFINE).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.PRESENCE).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).build();

    private RefineStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.REFINE, StatementSupport.StatementPolicy.reject(), config, validator);
    }

    public static @NonNull RefineStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new RefineStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull RefineStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new RefineStatementSupport(config, RFC7950_VALIDATOR);
    }

    public SchemaNodeIdentifier.Descendant parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return ArgumentUtils.parseDescendantSchemaNodeIdentifier(ctx, value);
    }

    protected RefineStatement createDeclared(BoundStmtCtx<SchemaNodeIdentifier.Descendant> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createRefine((String)ctx.getRawArgument(), (SchemaNodeIdentifier.Descendant)((SchemaNodeIdentifier.Descendant)ctx.getArgument()), substatements);
    }

    protected RefineStatement attachDeclarationReference(RefineStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateRefine((RefineStatement)stmt, (DeclarationReference)reference);
    }

    protected RefineEffectiveStatement createEffective(EffectiveStmtCtx.Current<SchemaNodeIdentifier.Descendant, RefineStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RefineEffectiveStatementImpl((RefineStatement)stmt.declared(), substatements, (SchemaNode)((StmtContext)Verify.verifyNotNull((Object)((StmtContext)stmt.namespaceItem(RefineTargetNamespace.INSTANCE, (Object)Empty.value())))).buildEffective());
    }
}

