/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class ActionStatementSupport
extends AbstractSchemaTreeStatementSupport<ActionStatement, ActionEffectiveStatement> {
    private static final ImmutableSet<StatementDefinition> ILLEGAL_PARENTS = ImmutableSet.of((Object)YangStmtMapping.NOTIFICATION, (Object)YangStmtMapping.RPC, (Object)YangStmtMapping.ACTION);
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ACTION).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.INPUT).addOptional((StatementDefinition)YangStmtMapping.OUTPUT).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).build();

    public ActionStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.ACTION, ActionStatementSupport.uninstantiatedPolicy(), config, SUBSTATEMENT_VALIDATOR);
    }

    public void onStatementAdded(StmtContext.Mutable<QName, ActionStatement, ActionEffectiveStatement> stmt) {
        QName argument = (QName)stmt.getArgument();
        SourceException.throwIf((boolean)StmtContextUtils.hasAncestorOfType(stmt, ILLEGAL_PARENTS), stmt, (String)"Action %s is defined within a notification, rpc or another action", (Object[])new Object[]{argument});
        SourceException.throwIf((boolean)StmtContextUtils.hasParentOfType(stmt, (StatementDefinition)YangStmtMapping.CASE), stmt, (String)"Action %s is defined within a case statement", (Object[])new Object[]{argument});
        SourceException.throwIf((boolean)StmtContextUtils.hasParentOfType(stmt, (StatementDefinition)YangStmtMapping.MODULE), stmt, (String)"Action %s is defined at the top level of a module", (Object[])new Object[]{stmt.getArgument()});
        StmtContextUtils.validateNoKeylessListAncestorOf(stmt, (String)"Action");
        super.onStatementAdded(stmt);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, ActionStatement, ActionEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, InputStatement.class) == null) {
            ActionStatementSupport.appendImplicitSubstatement(stmt, YangStmtMapping.INPUT.getStatementName());
        }
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, OutputStatement.class) == null) {
            ActionStatementSupport.appendImplicitSubstatement(stmt, YangStmtMapping.OUTPUT.getStatementName());
        }
    }

    protected ActionStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createAction((QName)((QName)ctx.getArgument()), substatements);
    }

    protected ActionStatement attachDeclarationReference(ActionStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateAction((ActionStatement)stmt, (DeclarationReference)reference);
    }

    protected ActionEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, ActionStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        StatementSourceReference ref = stmt.sourceReference();
        Verify.verify((!substatements.isEmpty() ? 1 : 0) != 0, (String)"Missing implicit input/output statements at %s", (Object)ref);
        try {
            return EffectiveStatements.createAction((ActionStatement)((ActionStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)EffectiveStmtUtils.historyAndStatusFlags((CopyableNode)stmt.history(), substatements), substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    public ActionEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, ActionStatement> stmt, ActionEffectiveStatement original) {
        return EffectiveStatements.copyAction((ActionEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)EffectiveStmtUtils.historyAndStatusFlags((CopyableNode)stmt.history(), original.effectiveSubstatements()));
    }

    public EffectiveStatementState extractEffectiveState(ActionEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof ActionDefinition), (String)"Unexpected statement %s", (Object)stmt);
        ActionDefinition schema = (ActionDefinition)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), EffectiveStmtUtils.historyAndStatusFlags(schema));
    }

    private static void appendImplicitSubstatement(StmtContext.Mutable<QName, ActionStatement, ActionEffectiveStatement> stmt, QName substatementName) {
        stmt.addEffectiveSubstatement(stmt.createUndeclaredSubstatement((StatementSupport)Verify.verifyNotNull((Object)((StatementSupport)stmt.getFromNamespace(StatementSupport.NAMESPACE, (Object)substatementName))), null));
    }
}

