/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.ir.IRArgument;
import org.opendaylight.yangtools.yang.ir.IRKeyword;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangIRSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ArgumentContextUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.source.ExplicitStatement;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public abstract class YangModelDependencyInfo {
    private static final String BELONGS_TO = YangStmtMapping.BELONGS_TO.getStatementName().getLocalName();
    private static final String IMPORT = YangStmtMapping.IMPORT.getStatementName().getLocalName();
    private static final String INCLUDE = YangStmtMapping.INCLUDE.getStatementName().getLocalName();
    private static final String MODULE = YangStmtMapping.MODULE.getStatementName().getLocalName();
    private static final String REVISION = YangStmtMapping.REVISION.getStatementName().getLocalName();
    private static final String REVISION_DATE = YangStmtMapping.REVISION_DATE.getStatementName().getLocalName();
    private static final String SUBMODULE = YangStmtMapping.SUBMODULE.getStatementName().getLocalName();
    private final String name;
    private final Revision revision;
    private final ImmutableSet<ModuleImport> submoduleIncludes;
    private final ImmutableSet<ModuleImport> moduleImports;
    private final ImmutableSet<ModuleImport> dependencies;

    YangModelDependencyInfo(String name, String formattedRevision, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
        this.name = name;
        this.revision = Revision.ofNullable((String)formattedRevision).orElse(null);
        this.moduleImports = imports;
        this.submoduleIncludes = includes;
        this.dependencies = ImmutableSet.builder().addAll(this.moduleImports).addAll(this.submoduleIncludes).build();
    }

    public ImmutableSet<ModuleImport> getDependencies() {
        return this.dependencies;
    }

    public String getName() {
        return this.name;
    }

    public String getFormattedRevision() {
        return this.revision != null ? this.revision.toString() : null;
    }

    public Optional<Revision> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.revision);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof YangModelDependencyInfo)) return false;
        YangModelDependencyInfo other = (YangModelDependencyInfo)obj;
        if (!Objects.equals(this.name, other.name)) return false;
        if (!Objects.equals(this.revision, other.revision)) return false;
        return true;
    }

    public static @NonNull YangModelDependencyInfo forIR(YangIRSchemaSource source) {
        return YangModelDependencyInfo.forIR(source.getRootStatement(), (SourceIdentifier)source.getIdentifier());
    }

    static @NonNull YangModelDependencyInfo forIR(IRStatement rootStatement, SourceIdentifier source) {
        IRKeyword keyword = rootStatement.keyword();
        Preconditions.checkArgument((boolean)(keyword instanceof IRKeyword.Unqualified), (String)"Invalid root statement %s", (Object)keyword);
        String arg = keyword.identifier();
        if (MODULE.equals(arg)) {
            return YangModelDependencyInfo.parseModuleContext(rootStatement, source);
        }
        if (SUBMODULE.equals(arg)) {
            return YangModelDependencyInfo.parseSubmoduleContext(rootStatement, source);
        }
        throw new IllegalArgumentException("Root of parsed AST must be either module or submodule");
    }

    public static YangModelDependencyInfo forYangText(YangTextSchemaSource yangText) throws IOException, YangSyntaxErrorException {
        YangStatementStreamSource source = YangStatementStreamSource.create(yangText);
        return YangModelDependencyInfo.forIR(source.rootStatement(), (SourceIdentifier)source.getIdentifier());
    }

    private static @NonNull YangModelDependencyInfo parseModuleContext(IRStatement module, SourceIdentifier source) {
        String name = YangModelDependencyInfo.safeStringArgument(source, module, "module name");
        String latestRevision = YangModelDependencyInfo.getLatestRevision(module, source);
        ImmutableSet<ModuleImport> imports = YangModelDependencyInfo.parseImports(module, source);
        ImmutableSet<ModuleImport> includes = YangModelDependencyInfo.parseIncludes(module, source);
        return new ModuleDependencyInfo(name, latestRevision, imports, includes);
    }

    private static ImmutableSet<ModuleImport> parseImports(IRStatement module, SourceIdentifier source) {
        HashSet<ModuleImportImpl> result = new HashSet<ModuleImportImpl>();
        for (IRStatement substatement : module.statements()) {
            if (!YangModelDependencyInfo.isBuiltin(substatement, IMPORT)) continue;
            String importedModuleName = YangModelDependencyInfo.safeStringArgument(source, substatement, "imported module name");
            String revisionDateStr = YangModelDependencyInfo.getRevisionDateString(substatement, source);
            result.add(new ModuleImportImpl(UnresolvedQName.Unqualified.of((String)importedModuleName), revisionDateStr != null ? Revision.of((String)revisionDateStr) : null));
        }
        return ImmutableSet.copyOf(result);
    }

    private static boolean isBuiltin(IRStatement stmt, String localName) {
        IRKeyword keyword = stmt.keyword();
        return keyword instanceof IRKeyword.Unqualified && localName.equals(keyword.identifier());
    }

    private static ImmutableSet<ModuleImport> parseIncludes(IRStatement module, SourceIdentifier source) {
        HashSet<ModuleImportImpl> result = new HashSet<ModuleImportImpl>();
        for (IRStatement substatement : module.statements()) {
            if (!YangModelDependencyInfo.isBuiltin(substatement, INCLUDE)) continue;
            String revisionDateStr = YangModelDependencyInfo.getRevisionDateString(substatement, source);
            String includeModuleName = YangModelDependencyInfo.safeStringArgument(source, substatement, "included submodule name");
            result.add(new ModuleImportImpl(UnresolvedQName.Unqualified.of((String)includeModuleName), revisionDateStr == null ? null : Revision.of((String)revisionDateStr)));
        }
        return ImmutableSet.copyOf(result);
    }

    private static String getRevisionDateString(IRStatement importStatement, SourceIdentifier source) {
        String revisionDateStr = null;
        for (IRStatement substatement : importStatement.statements()) {
            if (!YangModelDependencyInfo.isBuiltin(substatement, REVISION_DATE)) continue;
            revisionDateStr = YangModelDependencyInfo.safeStringArgument(source, substatement, "imported module revision-date");
        }
        return revisionDateStr;
    }

    public static String getLatestRevision(IRStatement module, SourceIdentifier source) {
        String latestRevision = null;
        for (IRStatement substatement : module.statements()) {
            if (!YangModelDependencyInfo.isBuiltin(substatement, REVISION)) continue;
            String currentRevision = YangModelDependencyInfo.safeStringArgument(source, substatement, "revision date");
            if (latestRevision != null && latestRevision.compareTo(currentRevision) >= 0) continue;
            latestRevision = currentRevision;
        }
        return latestRevision;
    }

    private static @NonNull YangModelDependencyInfo parseSubmoduleContext(IRStatement submodule, SourceIdentifier source) {
        String name = YangModelDependencyInfo.safeStringArgument(source, submodule, "submodule name");
        UnresolvedQName.Unqualified belongsTo = UnresolvedQName.Unqualified.of((String)YangModelDependencyInfo.parseBelongsTo(submodule, source));
        String latestRevision = YangModelDependencyInfo.getLatestRevision(submodule, source);
        ImmutableSet<ModuleImport> imports = YangModelDependencyInfo.parseImports(submodule, source);
        ImmutableSet<ModuleImport> includes = YangModelDependencyInfo.parseIncludes(submodule, source);
        return new SubmoduleDependencyInfo(name, latestRevision, belongsTo, imports, includes);
    }

    private static String parseBelongsTo(IRStatement submodule, SourceIdentifier source) {
        for (IRStatement substatement : submodule.statements()) {
            if (!YangModelDependencyInfo.isBuiltin(substatement, BELONGS_TO)) continue;
            return YangModelDependencyInfo.safeStringArgument(source, substatement, "belongs-to module name");
        }
        return null;
    }

    static String safeStringArgument(SourceIdentifier source, IRStatement stmt, String desc) {
        StatementSourceReference ref = YangModelDependencyInfo.getReference(source, stmt);
        IRArgument arg = stmt.argument();
        if (arg == null) {
            throw new IllegalArgumentException("Missing " + desc + " at " + ref);
        }
        return ArgumentContextUtils.rfc6020().stringFromStringContext(arg, ref);
    }

    private static StatementSourceReference getReference(SourceIdentifier source, IRStatement stmt) {
        return ExplicitStatement.atPosition((String)source.name().getLocalName(), (int)stmt.startLine(), (int)(stmt.startColumn() + 1));
    }

    public static final class ModuleDependencyInfo
    extends YangModelDependencyInfo {
        ModuleDependencyInfo(String name, String latestRevision, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
            super(name, latestRevision, imports, includes);
        }

        public String toString() {
            return "Module [name=" + this.getName() + ", revision=" + this.getRevision() + ", dependencies=" + this.getDependencies() + "]";
        }
    }

    private static final class ModuleImportImpl
    implements ModuleImport {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull UnresolvedQName.Unqualified moduleName;
        private final Revision revision;

        ModuleImportImpl(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull UnresolvedQName.Unqualified moduleName, @Nullable Revision revision) {
            this.moduleName = Objects.requireNonNull(moduleName, "Module name must not be null.");
            this.revision = revision;
        }

        public UnresolvedQName.Unqualified getModuleName() {
            return this.moduleName;
        }

        public Optional<Revision> getRevision() {
            return Optional.ofNullable(this.revision);
        }

        public String getPrefix() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getReference() {
            return Optional.empty();
        }

        public ImportEffectiveStatement asEffectiveStatement() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.moduleName);
            result = 31 * result + Objects.hashCode(this.revision);
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof ModuleImportImpl)) return false;
            ModuleImportImpl other = (ModuleImportImpl)obj;
            if (!this.moduleName.equals((Object)other.moduleName)) return false;
            if (!Objects.equals(this.revision, other.revision)) return false;
            return true;
        }

        public String toString() {
            return "ModuleImportImpl [name=" + this.moduleName + ", revision=" + this.revision + "]";
        }
    }

    public static final class SubmoduleDependencyInfo
    extends YangModelDependencyInfo {
        private final UnresolvedQName.Unqualified belongsTo;

        private SubmoduleDependencyInfo(String name, String latestRevision, UnresolvedQName.Unqualified belongsTo, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
            super(name, latestRevision, imports, includes);
            this.belongsTo = belongsTo;
        }

        public UnresolvedQName.Unqualified getParentModule() {
            return this.belongsTo;
        }

        public String toString() {
            return "Submodule [name=" + this.getName() + ", revision=" + this.getRevision() + ", dependencies=" + this.getDependencies() + "]";
        }
    }
}

