/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.notification;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

abstract class AbstractNotificationStatementSupport
extends AbstractSchemaTreeStatementSupport<NotificationStatement, NotificationEffectiveStatement> {
    AbstractNotificationStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.NOTIFICATION, AbstractNotificationStatementSupport.uninstantiatedPolicy(), config, validator);
    }

    protected final NotificationStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createNotification((QName)((QName)ctx.getArgument()), substatements);
    }

    protected final NotificationStatement attachDeclarationReference(NotificationStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateNotification((NotificationStatement)stmt, (DeclarationReference)reference);
    }

    protected final NotificationEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, NotificationStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        try {
            return EffectiveStatements.createNotification((NotificationStatement)((NotificationStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)EffectiveStmtUtils.historyAndStatusFlags((CopyableNode)stmt.history(), substatements), substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    public final NotificationEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, NotificationStatement> stmt, NotificationEffectiveStatement original) {
        return EffectiveStatements.copyNotification((NotificationEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)EffectiveStmtUtils.historyAndStatusFlags((CopyableNode)stmt.history(), original.effectiveSubstatements()));
    }

    public final EffectiveStatementState extractEffectiveState(NotificationEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof NotificationDefinition), (String)"Unexpected statement %s", (Object)stmt);
        NotificationDefinition schema = (NotificationDefinition)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), EffectiveStmtUtils.historyAndStatusFlags(schema));
    }
}

