/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnresolvedNumber;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueRange;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class RangeStatementSupport
extends AbstractStatementSupport<List<ValueRange>, RangeStatement, RangeEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.RANGE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.ERROR_APP_TAG).addOptional((StatementDefinition)YangStmtMapping.ERROR_MESSAGE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();

    public RangeStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.RANGE, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public ImmutableList<ValueRange> parseArgumentValue(StmtContext<?, ?, ?> ctx, String rangeArgument) {
        ArrayList<ValueRange> ranges = new ArrayList<ValueRange>();
        for (String singleRange : ArgumentUtils.PIPE_SPLITTER.split((CharSequence)rangeArgument)) {
            Number max;
            Iterator boundaries = ArgumentUtils.TWO_DOTS_SPLITTER.split((CharSequence)singleRange).iterator();
            Number min = RangeStatementSupport.parseDecimalConstraintValue(ctx, (String)boundaries.next());
            if (boundaries.hasNext()) {
                max = RangeStatementSupport.parseDecimalConstraintValue(ctx, (String)boundaries.next());
                SourceException.throwIf((ArgumentUtils.compareNumbers(min, max) == 1 ? 1 : 0) != 0, ctx, (String)"Range constraint %s has descending order of boundaries; should be ascending", (Object[])new Object[]{singleRange});
                SourceException.throwIf((boolean)boundaries.hasNext(), ctx, (String)"Wrong number of boundaries in range constraint %s", (Object[])new Object[]{singleRange});
            } else {
                max = min;
            }
            InferenceException.throwIf((ranges.size() > 1 && ArgumentUtils.compareNumbers(min, ((ValueRange)Iterables.getLast(ranges)).upperBound()) != 1 ? 1 : 0) != 0, ctx, (String)"Some of the value ranges in %s are not disjoint", (Object[])new Object[]{rangeArgument});
            ranges.add(ValueRange.of((Number)min, (Number)max));
        }
        return ImmutableList.copyOf(ranges);
    }

    protected RangeStatement createDeclared(BoundStmtCtx<List<ValueRange>> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createRange((String)ctx.getRawArgument(), (List)((List)ctx.getArgument()), substatements);
    }

    protected RangeStatement attachDeclarationReference(RangeStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateRange((RangeStatement)stmt, (DeclarationReference)reference);
    }

    protected RangeEffectiveStatement createEffective(EffectiveStmtCtx.Current<List<ValueRange>, RangeStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createRange((RangeStatement)((RangeStatement)stmt.declared()), substatements);
    }

    private static @NonNull Number parseDecimalConstraintValue(@NonNull StmtContext<?, ?, ?> ctx, @NonNull String value) {
        if ("max".equals(value)) {
            return UnresolvedNumber.max();
        }
        if ("min".equals(value)) {
            return UnresolvedNumber.min();
        }
        if (value.indexOf(46) != -1) {
            try {
                return Decimal64.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new SourceException(ctx, (Throwable)e, "Value %s is not a valid decimal number", new Object[]{value});
            }
        }
        try {
            return value.startsWith("-") ? Long.valueOf(value) : Uint64.valueOf((String)value).intern();
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx, (Throwable)e, "Value %s is not a valid integral range number", new Object[]{value});
        }
    }
}

