/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.ir;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yangtools.yang.ir.IRArgument;
import org.opendaylight.yangtools.yang.ir.IRKeyword;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.ir.StatementOutput;

final class StatementOutputV1
extends StatementOutput {
    private final Map<IRKeyword, Integer> keywords = new HashMap<IRKeyword, Integer>();
    private final Map<String, Integer> strings = new HashMap<String, Integer>();

    StatementOutputV1(DataOutput out) {
        super(out);
    }

    @Override
    void writeStatement(IRStatement stmt) throws IOException {
        int key;
        List<? extends IRStatement> statements = stmt.statements();
        int size = statements.size();
        int sizeBits = size == 0 ? 0 : (size <= 255 ? 8 : (size <= 65535 ? 16 : 24));
        IRKeyword keyword = stmt.keyword();
        Integer keyCode = this.keywords.get(keyword);
        int keyBits = keyCode != null ? ((key = keyCode.intValue()) <= 255 ? 160 : (size <= 65535 ? 192 : 224)) : (keyword instanceof IRKeyword.Qualified ? 32 : 0);
        IRArgument argument = stmt.argument();
        if (stmt instanceof IRStatement.Z22) {
            this.writeHeader(keyBits, 1, sizeBits, argument);
            this.out.writeShort(stmt.startLine());
            this.out.writeShort(stmt.startColumn());
        } else if (stmt instanceof IRStatement.Z31) {
            IRStatement.Z31 z31 = (IRStatement.Z31)stmt;
            this.writeHeader(keyBits, 2, sizeBits, argument);
            this.out.writeInt(z31.value());
        } else {
            this.writeHeader(keyBits, 3, sizeBits, argument);
            this.out.writeInt(stmt.startLine());
            this.out.writeInt(stmt.startColumn());
        }
        switch (keyBits) {
            case 160: {
                this.out.writeByte(keyCode);
                break;
            }
            case 192: {
                this.out.writeShort(keyCode);
                break;
            }
            case 224: {
                this.out.writeInt(keyCode);
                break;
            }
            case 32: {
                this.writeString(keyword.prefix());
                this.writeString(keyword.identifier());
                this.keywords.put(keyword, this.keywords.size());
                break;
            }
            case 0: {
                this.writeString(keyword.identifier());
                this.keywords.put(keyword, this.keywords.size());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled key bits " + keyBits);
            }
        }
        if (argument != null) {
            this.writeArgument(argument);
        }
        switch (sizeBits) {
            case 0: {
                return;
            }
            case 8: {
                this.out.writeByte(statements.size());
                break;
            }
            case 16: {
                this.out.writeShort(size);
                break;
            }
            case 24: {
                this.out.writeInt(size);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled size bits " + sizeBits);
            }
        }
        for (IRStatement iRStatement : statements) {
            this.writeStatement(iRStatement);
        }
    }

    private void writeString(String str) throws IOException {
        Integer key = this.strings.get(str);
        if (key != null) {
            this.writeStringRef(key);
        } else {
            this.writeStringDef(0, str);
        }
    }

    private void writeStringDef(int bits, String str) throws IOException {
        this.strings.put(str, this.strings.size());
        int length = str.length();
        if (length <= 16383) {
            this.out.writeByte(0 | bits);
            this.out.writeUTF(str);
        } else if (length <= 0x100000) {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            if (bytes.length < 65536) {
                this.out.writeByte(0x20 | bits);
                this.out.writeShort(bytes.length);
            } else {
                this.out.writeByte(0x30 | bits);
                this.out.writeInt(bytes.length);
            }
            this.out.write(bytes);
        } else {
            this.out.writeByte(0x40 | bits);
            this.out.writeInt(length);
            this.out.writeChars(str);
        }
    }

    private void writeStringRef(int strCode) throws IOException {
        if (strCode <= 255) {
            this.out.writeByte(80);
            this.out.writeByte(strCode);
        } else if (strCode <= 65535) {
            this.out.writeByte(96);
            this.out.writeShort(strCode);
        } else {
            this.out.writeByte(112);
            this.out.writeInt(strCode);
        }
    }

    private void writeHeader(int keyBits, int locationBits, int sizeBits, IRArgument argument) throws IOException {
        int argBits = argument != null ? 4 : 0;
        this.out.writeByte(keyBits | sizeBits | argBits | locationBits);
    }

    private void writeArgument(IRArgument argument) throws IOException {
        if (argument instanceof IRArgument.Single) {
            this.writeArgument((IRArgument.Single)argument);
        } else if (argument instanceof IRArgument.Concatenation) {
            this.writeArgument((IRArgument.Concatenation)argument);
        } else {
            throw new IllegalStateException("Unhandled argument " + argument);
        }
    }

    private void writeArgument(IRArgument.Single argument) throws IOException {
        int type = argument.isValidIdentifier() ? 1 : (argument.needQuoteCheck() ? 4 : (argument.needUnescape() ? 2 : 3));
        String str = argument.string();
        Integer existing = this.strings.get(str);
        if (existing != null) {
            int strCode = existing;
            if (strCode <= 255) {
                this.out.writeByte(type | 0x50);
                this.out.writeByte(strCode);
            } else if (strCode <= 65535) {
                this.out.writeByte(type | 0x60);
                this.out.writeShort(strCode);
            } else {
                this.out.writeByte(type | 0x70);
                this.out.writeInt(strCode);
            }
        } else {
            this.writeStringDef(type, str);
        }
    }

    private void writeArgument(IRArgument.Concatenation argument) throws IOException {
        List<? extends IRArgument.Single> parts = argument.parts();
        int size = parts.size();
        if (size <= 255) {
            this.out.writeByte(5);
            this.out.writeByte(size);
        } else if (size <= 65535) {
            this.out.writeByte(6);
            this.out.writeShort(size);
        } else {
            this.out.writeByte(7);
            this.out.writeInt(size);
        }
        for (IRArgument.Single single : parts) {
            this.writeArgument(single);
        }
    }
}

