/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

final class YangTextFileSchemaSource
extends YangTextSchemaSource
implements Delegator<Path> {
    private final @NonNull Path path;

    YangTextFileSchemaSource(SourceIdentifier identifier, Path path) {
        super(identifier);
        this.path = Objects.requireNonNull(path);
    }

    public Path getDelegate() {
        return this.path;
    }

    public InputStream openStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("path", (Object)this.path);
    }

    @Override
    public Optional<String> getSymbolicName() {
        return Optional.of(this.path.toString());
    }
}

