/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import java.util.Collection;
import java.util.Map;
import org.opendaylight.yangtools.yang.model.api.source.SourceDependency;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.spi.source.SourceInfo;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.repo.DependencyResolver;

final class RevisionDependencyResolver
extends DependencyResolver {
    RevisionDependencyResolver(Map<SourceIdentifier, SourceInfo> depInfo) {
        super(depInfo);
    }

    @Override
    YangParserConfiguration parserConfig() {
        return YangParserConfiguration.DEFAULT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean isKnown(Collection<SourceIdentifier> haystack, SourceDependency dependency) {
        if (haystack.contains(new SourceIdentifier(dependency.name(), dependency.revision()))) return true;
        if (dependency.revision() != null) return false;
        if (!haystack.stream().anyMatch(arg_0 -> ((SourceDependency)dependency).isSatisfiedBy(arg_0))) return false;
        return true;
    }
}

