/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.impl.AbstractImmutableDataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.impl.ImmutableLeafNode;
import org.opendaylight.yangtools.yang.data.spi.node.impl.ImmutableMapEntryNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImmutableMapEntryNodeBuilder
extends AbstractImmutableDataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>
implements MapEntryNode.Builder {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableMapEntryNodeBuilder.class);
    private final Map<QName, YangInstanceIdentifier.NodeIdentifier> childrenQNamesToPaths;

    public ImmutableMapEntryNodeBuilder() {
        this.childrenQNamesToPaths = new LinkedHashMap<QName, YangInstanceIdentifier.NodeIdentifier>();
    }

    public ImmutableMapEntryNodeBuilder(int sizeHint) {
        super(sizeHint);
        this.childrenQNamesToPaths = new LinkedHashMap<QName, YangInstanceIdentifier.NodeIdentifier>(sizeHint);
    }

    private ImmutableMapEntryNodeBuilder(ImmutableMapEntryNode node) {
        super(node.name(), node.children);
        this.childrenQNamesToPaths = new LinkedHashMap<QName, YangInstanceIdentifier.NodeIdentifier>();
        ImmutableMapEntryNodeBuilder.fillQNames((Iterable<DataContainerChild>)node.body(), this.childrenQNamesToPaths);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MapEntryNode.Builder create(MapEntryNode node) {
        if (node instanceof ImmutableMapEntryNode) {
            ImmutableMapEntryNode immutableNode = (ImmutableMapEntryNode)node;
            return new ImmutableMapEntryNodeBuilder(immutableNode);
        }
        throw new UnsupportedOperationException("Cannot initialize from class " + node.getClass());
    }

    private static void fillQNames(Iterable<DataContainerChild> iterable, Map<QName, YangInstanceIdentifier.NodeIdentifier> out) {
        for (DataContainerChild child : iterable) {
            ImmutableMapEntryNodeBuilder.putQName(out, child);
        }
    }

    private static void putQName(Map<QName, YangInstanceIdentifier.NodeIdentifier> map, DataContainerChild child) {
        YangInstanceIdentifier.NodeIdentifier identifier = child.name();
        map.put(identifier.getNodeType(), identifier);
    }

    @Override
    public DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> withValue(Collection<DataContainerChild> withValue) {
        ImmutableMapEntryNodeBuilder.fillQNames(withValue, this.childrenQNamesToPaths);
        return super.withValue(withValue);
    }

    @Override
    public DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> withChild(DataContainerChild child) {
        ImmutableMapEntryNodeBuilder.putQName(this.childrenQNamesToPaths, child);
        return super.withChild(child);
    }

    public MapEntryNode build() {
        YangInstanceIdentifier.NodeIdentifierWithPredicates name = (YangInstanceIdentifier.NodeIdentifierWithPredicates)this.getNodeIdentifier();
        for (Map.Entry key : name.entrySet()) {
            Object actual;
            DataContainerChild childNode = this.getChild(this.childrenQNamesToPaths.get(key.getKey()));
            if (childNode == null) {
                ImmutableLeafNode leaf = ImmutableLeafNode.of(new YangInstanceIdentifier.NodeIdentifier((QName)key.getKey()), key.getValue());
                LOG.debug("Adding leaf {} implied by key {}", leaf, (Object)key);
                this.withChild((DataContainerChild)leaf);
                continue;
            }
            QName keyQName = (QName)key.getKey();
            Object expected = key.getValue();
            if (Objects.equals(expected, actual = childNode.body()) || Objects.deepEquals(expected, actual)) continue;
            throw new IllegalStateException("Illegal value for key: %s, in: %s, actual value: %s, expected value from key: %s".formatted(keyQName, name, actual, expected));
        }
        return new ImmutableMapEntryNode((YangInstanceIdentifier.NodeIdentifierWithPredicates)this.getNodeIdentifier(), this.buildValue());
    }
}

