/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node;

import com.google.common.collect.Interner;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemLeafSetNode;

public final class InterningLeafSetNodeBuilder<T>
implements SystemLeafSetNode.Builder<T> {
    private final Interner<LeafSetEntryNode<T>> interner;
    private final SystemLeafSetNode.Builder<T> delegate;

    public InterningLeafSetNodeBuilder(SystemLeafSetNode.Builder<T> delegate, Interner<LeafSetEntryNode<T>> interner) {
        this.delegate = Objects.requireNonNull(delegate);
        this.interner = Objects.requireNonNull(interner);
    }

    public SystemLeafSetNode.Builder<T> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier nodeIdentifier) {
        this.delegate.withNodeIdentifier(nodeIdentifier);
        return this;
    }

    public SystemLeafSetNode.Builder<T> withValue(Collection<LeafSetEntryNode<T>> value) {
        this.delegate.withValue(value);
        return this;
    }

    public SystemLeafSetNode.Builder<T> withChild(LeafSetEntryNode<T> child) {
        this.delegate.withChild((LeafSetEntryNode)this.interner.intern(child));
        return this;
    }

    public SystemLeafSetNode.Builder<T> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.delegate.withoutChild(key);
        return this;
    }

    public SystemLeafSetNode.Builder<T> withChildValue(T child) {
        throw new UnsupportedOperationException();
    }

    public SystemLeafSetNode.Builder<T> addChild(LeafSetEntryNode<T> child) {
        return this.withChild(child);
    }

    public SystemLeafSetNode.Builder<T> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    public SystemLeafSetNode<T> build() {
        return (SystemLeafSetNode)this.delegate.build();
    }
}

