/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8819.model.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8819.model.api.Tag;

public record Prefix(@NonNull String value) {
    private static final Interner<@NonNull Prefix> INTERNER = Interners.newWeakInterner();
    public static final @NonNull Prefix IETF = new Prefix("ietf:").intern();
    public static final @NonNull Prefix VENDOR = new Prefix("vendor:").intern();
    public static final @NonNull Prefix USER = new Prefix("user:").intern();

    public Prefix(@NonNull String value) {
        Objects.requireNonNull(value);
        Preconditions.checkArgument((boolean)Tag.isValidValue(value), (String)"Invalid prefix value '%s'.", (Object)value);
    }

    public @NonNull Prefix intern() {
        return (Prefix)INTERNER.intern((Object)this);
    }
}

