/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceException;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;

public class SourceException
extends StatementSourceException {
    private static final long serialVersionUID = 1L;

    public SourceException(@NonNull String message, @NonNull StatementSourceReference sourceRef) {
        super(sourceRef, message);
    }

    public SourceException(@NonNull String message, @NonNull StatementSourceReference sourceRef, Throwable cause) {
        super(sourceRef, message, cause);
    }

    public SourceException(@NonNull StatementSourceReference source, @NonNull String format, Object ... args) {
        super(source, format, args);
    }

    public SourceException(@NonNull StatementSourceReference source, Throwable cause, @NonNull String format, Object ... args) {
        super(source, cause, format, args);
    }

    public SourceException(@NonNull String message, @NonNull CommonStmtCtx stmt) {
        super(stmt.sourceReference(), message);
    }

    public SourceException(@NonNull String message, @NonNull CommonStmtCtx stmt, Throwable cause) {
        super(stmt.sourceReference(), message, cause);
    }

    public SourceException(@NonNull CommonStmtCtx stmt, @NonNull String format, Object ... args) {
        super(stmt.sourceReference(), format, args);
    }

    public SourceException(@NonNull CommonStmtCtx stmt, Throwable cause, @NonNull String format, Object ... args) {
        this(stmt.sourceReference(), cause, format, args);
    }

    public static void throwIf(boolean expression, @NonNull CommonStmtCtx stmt, @NonNull String format, Object ... args) {
        if (expression) {
            throw new SourceException(stmt, format, args);
        }
    }

    public static void throwIf(boolean expression, @NonNull StatementSourceReference source, @NonNull String format, Object ... args) {
        if (expression) {
            throw new SourceException(source, format, args);
        }
    }

    public static <T> @NonNull T throwIfNull(@Nullable T obj, @NonNull StatementSourceReference source, @NonNull String format, Object ... args) {
        if (obj == null) {
            throw new SourceException(source, format, args);
        }
        return obj;
    }

    public static <T> @NonNull T throwIfNull(@Nullable T obj, @NonNull CommonStmtCtx stmt, @NonNull String format, Object ... args) {
        if (obj == null) {
            throw new SourceException(stmt.sourceReference(), format, args);
        }
        return obj;
    }

    public static <T> @NonNull T unwrap(Optional<T> opt, @NonNull StatementSourceReference source, @NonNull String format, Object ... args) {
        SourceException.throwIf(opt.isEmpty(), source, format, args);
        return opt.orElseThrow();
    }

    public static <T> @NonNull T unwrap(Optional<T> opt, @NonNull CommonStmtCtx stmt, @NonNull String format, Object ... args) {
        SourceException.throwIf(opt.isEmpty(), stmt, format, args);
        return opt.orElseThrow();
    }
}

