/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationInFile;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationInText;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.StatementOrigin;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;

@NonNullByDefault
public abstract class StatementDeclaration
extends StatementSourceReference
implements DeclarationReference {
    @Override
    public final StatementOrigin statementOrigin() {
        return StatementOrigin.DECLARATION;
    }

    @Override
    public final @NonNull DeclarationReference declarationReference() {
        return this;
    }

    @Override
    public final String toHumanReadable() {
        int column;
        StringBuilder sb = new StringBuilder();
        String file = this.file();
        sb.append(file != null ? file : "<UNKNOWN>");
        int line = this.line();
        if (line > 0) {
            sb.append(':').append(line);
        }
        if ((column = this.column()) > 0) {
            sb.append(':').append(column);
        }
        return sb.toString();
    }

    @Override
    public final String toString() {
        return this.toHumanReadable();
    }

    protected abstract @Nullable String file();

    protected abstract int line();

    protected abstract int column();

    public static abstract class InTextFile
    extends InText
    implements DeclarationInFile {
        @Override
        protected final @NonNull String file() {
            return this.fileName();
        }
    }

    public static abstract class InText
    extends StatementDeclaration
    implements DeclarationInText {
        @Override
        protected final int line() {
            return this.startLine();
        }

        @Override
        protected final int column() {
            return this.startColumn();
        }

        @Override
        protected @Nullable String file() {
            return null;
        }
    }
}

