/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.AbstractIndentingNormalizedNodeStreamWriter;

@Beta
public final class FormattingNormalizedNodeStreamWriter
extends AbstractIndentingNormalizedNodeStreamWriter {
    private final StringBuilder sb = new StringBuilder();
    private boolean closed;

    public FormattingNormalizedNodeStreamWriter() {
    }

    public FormattingNormalizedNodeStreamWriter(int indentSize) {
        super(indentSize);
    }

    public @NonNull String result() {
        Preconditions.checkState((boolean)this.closed, (Object)"Attempted to access the result of unclosed writer");
        return this.sb.toString();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    void enterUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        this.sb.append(indent).append(name).append("[](no key)\n");
    }

    @Override
    void enterUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        this.sb.append(indent).append(name).append("(no key)\n");
    }

    @Override
    void enterMapNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        this.sb.append(indent).append(name).append("(key)\n");
    }

    @Override
    void enterMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, String indent) {
        this.sb.append(indent).append(identifier).append("[](key)\n");
    }

    @Override
    void enterLeafSet(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        this.sb.append(indent).append(name).append("(leaf-list)\n");
    }

    @Override
    void enterContainerNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        this.sb.append(indent).append(name).append("(container)\n");
    }

    @Override
    void enterChoiceNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        this.sb.append(indent).append(name).append("(choice)\n");
    }

    @Override
    void enterLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name, String indent) {
        this.sb.append(indent).append(name.getNodeType()).append("(entry)\n");
    }

    @Override
    void enterLeafNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        this.sb.append(indent).append(name).append("(leaf)\n");
    }

    @Override
    void enterAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        this.sb.append(indent).append(name).append("(anyxml)\n");
    }

    @Override
    void enterAnydataNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        this.sb.append(indent).append(name).append("(anydata)\n");
    }

    @Override
    void exitNode(String indent) {
        this.sb.append(indent).append("(end)\n");
    }

    @Override
    void scalarValue(Object value, String indent) {
        this.sb.append(indent).append('(').append(value.getClass().getSimpleName()).append(")=").append(value).append('\n');
    }
}

