/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;

@Beta
public abstract class AbstractEffectiveUnknownSchmemaNode<A, D extends UnknownStatement<A>>
extends AbstractDeclaredEffectiveStatement<A, D>
implements EffectiveStatementMixins.DocumentedNodeMixin<A, D>,
UnknownSchemaNode {
    private final @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> substatements;
    private final @NonNull D declared;
    private final @NonNull A argument;
    @Deprecated(since="7.0.9")
    private final boolean addedByUses;
    private final boolean augmenting;

    protected AbstractEffectiveUnknownSchmemaNode(@NonNull D declared, A argument, CopyableNode history, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        this.argument = Objects.requireNonNull(argument);
        this.declared = (UnknownStatement)Objects.requireNonNull(declared);
        this.substatements = Objects.requireNonNull(substatements);
        this.augmenting = history.isAugmenting();
        this.addedByUses = history.isAddedByUses();
    }

    public final A argument() {
        return this.argument;
    }

    @Override
    public final @NonNull D getDeclared() {
        return this.declared;
    }

    @Override
    public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return this.substatements;
    }

    public final QName getNodeType() {
        return this.statementDefinition().getStatementName();
    }

    public final String getNodeParameter() {
        String rawArgument = this.getDeclared().rawArgument();
        return rawArgument == null ? "" : rawArgument;
    }

    @Deprecated(forRemoval=true)
    public final boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Deprecated
    public final boolean isAugmenting() {
        return this.augmenting;
    }

    public final <T> Collection<T> allSubstatementsOfType(Class<T> type) {
        return (Collection)Collection.class.cast(Collections2.filter(this.effectiveSubstatements(), type::isInstance));
    }

    public final Status getStatus() {
        return this.findFirstEffectiveSubstatementArgument(StatusEffectiveStatement.class).orElse(Status.CURRENT);
    }
}

