/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.AbstractEffectiveModelContextProvider;

@Beta
public abstract class AbstractEffectiveStatementInference<T extends EffectiveStatement<?, ?>>
extends AbstractEffectiveModelContextProvider
implements EffectiveStatementInference {
    protected AbstractEffectiveStatementInference(@NonNull EffectiveModelContext modelContext) {
        super(modelContext);
    }

    public abstract List<T> statementPath();

    @Beta
    public static abstract class WithPath<T extends EffectiveStatement<?, ?>>
    extends AbstractEffectiveStatementInference<T> {
        private final @NonNull List<T> path;

        protected WithPath(@NonNull EffectiveModelContext modelContext, @NonNull ImmutableList<T> path) {
            super(modelContext);
            this.path = (List)Objects.requireNonNull(path);
        }

        protected WithPath(@NonNull EffectiveModelContext modelContext, @NonNull List<? extends T> path) {
            super(modelContext);
            this.path = ImmutableList.copyOf(path);
        }

        @Override
        public final List<T> statementPath() {
            return this.path;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("path", this.path);
        }
    }
}

