/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.ri.type.AbstractRestrictedType;
import org.opendaylight.yangtools.yang.model.ri.type.AbstractTypeDefinition;

abstract class AbstractDerivedType<T extends TypeDefinition<T>>
extends AbstractTypeDefinition<T> {
    private final @NonNull T baseType;
    private final Object defaultValue;
    private final String description;
    private final String reference;
    private final @NonNull Status status;
    private final String units;

    AbstractDerivedType(T baseType, QName qname, Object defaultValue, String description, String reference, Status status, String units, Collection<? extends UnknownSchemaNode> unknownSchemNodes) {
        super(qname, unknownSchemNodes);
        this.baseType = (TypeDefinition)Objects.requireNonNull(baseType);
        this.status = Objects.requireNonNull(status);
        this.defaultValue = defaultValue;
        this.description = description;
        this.reference = reference;
        this.units = units;
    }

    public final T getBaseType() {
        return (T)(this.baseType instanceof AbstractRestrictedType ? this.baseType.getBaseType() : this.baseType);
    }

    final T baseType() {
        return this.baseType;
    }

    public final Optional<? extends Object> getDefaultValue() {
        return this.defaultValue != null ? Optional.of(this.defaultValue) : this.baseType.getDefaultValue();
    }

    public final Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public final Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Optional<String> getUnits() {
        return this.units != null ? Optional.of(this.units) : this.baseType.getUnits();
    }

    @Override
    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("baseType", this.baseType).add("default", this.defaultValue).add("description", (Object)this.description).add("qname", (Object)this.getQName()).add("reference", (Object)this.reference).add("status", (Object)this.status).add("units", (Object)this.units).toString();
    }
}

