/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.AbstractSimpleIdentifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class NamespaceBehaviour<K, V>
extends AbstractSimpleIdentifiable<ParserNamespace<K, V>> {
    protected NamespaceBehaviour(ParserNamespace<K, V> identifier) {
        super(identifier);
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> global(ParserNamespace<K, V> identifier) {
        return new StorageSpecific<K, V>(identifier, StorageNodeType.GLOBAL);
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> sourceLocal(ParserNamespace<K, V> identifier) {
        return new StorageSpecific<K, V>(identifier, StorageNodeType.SOURCE_LOCAL_SPECIAL);
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> statementLocal(ParserNamespace<K, V> identifier) {
        return new StatementLocal<K, V>(identifier);
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> rootStatementLocal(ParserNamespace<K, V> identifier) {
        return new StorageSpecific<K, V>(identifier, StorageNodeType.ROOT_STATEMENT_LOCAL);
    }

    public static <K, V> @NonNull NamespaceBehaviour<K, V> treeScoped(ParserNamespace<K, V> identifier) {
        return new TreeScoped<K, V>(identifier);
    }

    public abstract V getFrom(NamespaceStorageNode var1, K var2);

    public final Optional<Map.Entry<K, V>> getFrom(NamespaceStorageNode storage, NamespaceKeyCriterion<K> criterion) {
        Map<K, V> mappings = this.getAllFrom(storage);
        if (mappings == null) {
            return Optional.empty();
        }
        Map.Entry<K, V> match = null;
        for (Map.Entry<K, V> entry : mappings.entrySet()) {
            K key = entry.getKey();
            if (!criterion.match(key)) continue;
            if (match != null) {
                K selected = criterion.select(match.getKey(), key);
                if (selected.equals(match.getKey())) continue;
                Verify.verify((selected == key ? 1 : 0) != 0, (String)"Criterion %s selected invalid key %s from candidates [%s %s]", selected, match.getKey(), key);
            }
            match = entry;
        }
        return Optional.ofNullable(match);
    }

    public abstract Map<K, V> getAllFrom(NamespaceStorageNode var1);

    public abstract void addTo(NamespaceStorageNode var1, K var2, V var3);

    protected final V getFromLocalStorage(NamespaceStorageNode storage, K key) {
        return storage.getFromLocalStorage((ParserNamespace)this.getIdentifier(), key);
    }

    protected final Map<K, V> getAllFromLocalStorage(NamespaceStorageNode storage) {
        return storage.getAllFromLocalStorage((ParserNamespace)this.getIdentifier());
    }

    protected final void addToStorage(NamespaceStorageNode storage, K key, V value) {
        storage.putToLocalStorage((ParserNamespace)this.getIdentifier(), key, value);
    }

    protected static NamespaceStorageNode findClosestTowardsRoot(NamespaceStorageNode storage, StorageNodeType type) {
        NamespaceStorageNode current;
        for (current = storage; current != null && current.getStorageNodeType() != type; current = current.getParentNamespaceStorage()) {
        }
        return current;
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("identifier", this.getIdentifier());
    }

    static final class StorageSpecific<K, V>
    extends AbstractSpecific<K, V> {
        private final StorageNodeType storageType;

        StorageSpecific(ParserNamespace<K, V> identifier, StorageNodeType type) {
            super(identifier);
            this.storageType = Objects.requireNonNull(type);
        }

        @Override
        NamespaceStorageNode findStorageNode(NamespaceStorageNode storage) {
            return StorageSpecific.findClosestTowardsRoot(storage, this.storageType);
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper.add("type", (Object)this.storageType));
        }
    }

    public static enum StorageNodeType {
        GLOBAL,
        SOURCE_LOCAL_SPECIAL,
        STATEMENT_LOCAL,
        ROOT_STATEMENT_LOCAL;

    }

    static final class StatementLocal<K, V>
    extends AbstractSpecific<K, V> {
        StatementLocal(ParserNamespace<K, V> identifier) {
            super(identifier);
        }

        @Override
        NamespaceStorageNode findStorageNode(NamespaceStorageNode storage) {
            return storage;
        }
    }

    static final class TreeScoped<K, V>
    extends NamespaceBehaviour<K, V> {
        TreeScoped(ParserNamespace<K, V> identifier) {
            super(identifier);
        }

        @Override
        public V getFrom(NamespaceStorageNode storage, K key) {
            for (NamespaceStorageNode current = storage; current != null; current = current.getParentNamespaceStorage()) {
                Object val = this.getFromLocalStorage(current, key);
                if (val == null) continue;
                return val;
            }
            return null;
        }

        @Override
        public Map<K, V> getAllFrom(NamespaceStorageNode storage) {
            for (NamespaceStorageNode current = storage; current != null; current = current.getParentNamespaceStorage()) {
                Map val = this.getAllFromLocalStorage(current);
                if (val == null) continue;
                return val;
            }
            return null;
        }

        @Override
        public void addTo(NamespaceStorageNode storage, K key, V value) {
            this.addToStorage(storage, key, value);
        }
    }

    public static interface NamespaceStorageNode {
        public StorageNodeType getStorageNodeType();

        public @Nullable NamespaceStorageNode getParentNamespaceStorage();

        public <K, V> @Nullable V getFromLocalStorage(ParserNamespace<K, V> var1, K var2);

        public <K, V> @Nullable Map<K, V> getAllFromLocalStorage(ParserNamespace<K, V> var1);

        public <K, V> @Nullable V putToLocalStorage(ParserNamespace<K, V> var1, K var2, V var3);

        public <K, V> @Nullable V putToLocalStorageIfAbsent(ParserNamespace<K, V> var1, K var2, V var3);
    }

    static abstract class AbstractSpecific<K, V>
    extends NamespaceBehaviour<K, V> {
        AbstractSpecific(ParserNamespace<K, V> identifier) {
            super(identifier);
        }

        @Override
        public final V getFrom(NamespaceStorageNode storage, K key) {
            return this.getFromLocalStorage(this.findStorageNode(storage), key);
        }

        @Override
        public final Map<K, V> getAllFrom(NamespaceStorageNode storage) {
            return this.getAllFromLocalStorage(this.findStorageNode(storage));
        }

        @Override
        public final void addTo(NamespaceStorageNode storage, K key, V value) {
            this.addToStorage(this.findStorageNode(storage), key, value);
        }

        abstract NamespaceStorageNode findStorageNode(NamespaceStorageNode var1);
    }

    @Beta
    public static interface OnDemandSchemaTreeStorageNode
    extends NamespaceStorageNode {
        public <D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>> @Nullable StmtContext<QName, D, E> requestSchemaTreeChild(QName var1);
    }

    public static interface Registry {
        public <K, V> NamespaceBehaviour<K, V> getNamespaceBehaviour(ParserNamespace<K, V> var1);
    }
}

