/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.HierarchicalIdentifier;

public abstract class AbstractHierarchicalIdentifier<T extends AbstractHierarchicalIdentifier<T, I>, I>
implements HierarchicalIdentifier<T> {
    private static final long serialVersionUID = 1L;

    @Override
    public final boolean contains(T other) {
        if (this != other) {
            Iterator<I> oit = ((AbstractHierarchicalIdentifier)other).itemIterator();
            Iterator<I> it = this.itemIterator();
            while (it.hasNext()) {
                if (oit.hasNext() && it.next().equals(oit.next())) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract @NonNull Iterator<@NonNull I> itemIterator();

    protected abstract @NonNull Object writeReplace() throws ObjectStreamException;

    protected final void throwNSE() throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }

    @Override
    public abstract int hashCode();

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract String toString();

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.throwNSE();
    }
}

